/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.zapi.parser;

import com.google.common.base.Function;
import com.netapp.nmsdk.common.api.annotation.DocEnum;
import com.netapp.nmsdk.common.api.annotation.StatusEnum;
import com.netapp.nmsdk.common.cli.CliParameter;
import com.netapp.nmsdk.common.cli.CliParser;
import com.netapp.nmsdk.common.cli.binding.CommandBinding;
import com.netapp.nmsdk.common.cli.enumeration.LowerCaseCliEnumTransformer;
import com.netapp.nmsdk.common.util.CollectionUtils;
import com.netapp.nmsdk.common.util.StringUtils;
import com.netapp.zapi.parser.ZapidocFilter;
import com.netapp.zapi.parser.ZapidocParser;
import com.netapp.zapi.parser.filter.ApiCategoryFilter;
import com.netapp.zapi.parser.filter.ApiFamilyFilter;
import com.netapp.zapi.parser.filter.ApiStatusFilter;
import com.netapp.zapi.parser.filter.FieldDocFilter;
import com.netapp.zapi.parser.filter.FieldScopeFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractZapidocFacade {
    protected ZapidocFilter filter = new ZapidocFilter();
    protected String namespace = "filer";
    protected List<File> zapidocs;
    protected InputStream zapiStream = null;
    protected List<File> internableFieldFiles;
    protected ZapidocParser parser;
    protected boolean printLog = true;

    @CliParameter(option="zapidoc")
    public void setZapidocs(String[] zapidocs) {
        this.zapidocs = CollectionUtils.transform(Arrays.asList(zapidocs), new ArrayList(), new Function<String, File>(){

            @Override
            public File apply(String s) {
                return new File(s);
            }
        });
    }

    @CliParameter(option="internable")
    public void setInternableFieldFiles(String[] internableFieldFiles) {
        this.internableFieldFiles = CollectionUtils.transform(Arrays.asList(internableFieldFiles), new ArrayList(), new Function<String, File>(){

            @Override
            public File apply(String s) {
                return new File(s);
            }
        });
    }

    @CliParameter(option="namespace")
    public void setNamespace(String namespace) {
        if (!StringUtils.isEmpty(namespace)) {
            this.namespace = namespace;
        }
    }

    @CliParameter(option="api-category")
    public void setApiCategory(String[] category) {
        if (category.length > 0) {
            this.filter.addApiFilter(new ApiCategoryFilter(category));
        }
    }

    @CliParameter(option="api-family")
    public void setApiFamily(String[] family) {
        if (family.length > 0) {
            this.filter.addApiFilter(new ApiFamilyFilter(family));
            this.filter.addFieldFilter(new FieldScopeFilter(family));
        }
    }

    @CliParameter(option="api-status", enumTransformer=LowerCaseCliEnumTransformer.class)
    public void setStatus(StatusEnum[] status) {
        if (status.length > 0) {
            this.filter.addApiFilter(new ApiStatusFilter(status));
        }
    }

    @CliParameter(option="field-doc", enumTransformer=LowerCaseCliEnumTransformer.class)
    public void setFieldDoc(DocEnum[] doc) {
        this.filter.addFieldFilter(new FieldDocFilter(doc));
    }

    public void setZapiInputStream(InputStream inputStream) {
        this.zapiStream = inputStream;
    }

    public void enablePrintLog(boolean value) {
        this.printLog = value;
    }

    protected ZapidocParser constructParser() throws IOException {
        if (this.zapiStream != null) {
            if (this.parser == null) {
                this.parser = new ZapidocParser(this.zapiStream, this.filter, this.printLog);
            }
            return this.parser;
        }
        if (this.zapidocs == null || this.zapidocs.isEmpty()) {
            throw new IllegalStateException("At least one zapidoc must be provided.");
        }
        if (this.parser == null) {
            this.parser = new ZapidocParser(this.zapidocs, this.filter, this.internableFieldFiles);
        }
        return this.parser;
    }

    protected void printGlobalOptions() {
        System.err.println("        -zapidoc <zapidoc> [...]");
        System.err.println("        [-namespace <namespace>] (default \"filer\")");
        System.err.println("        [-api-category <category> ...] (default all)");
        System.err.println("        [-api-family <family> ...] (default all)");
        System.err.println("        [-api-status <status> ...] (default all)");
        System.err.println("        [-field-doc hidden] (default none)");
        System.err.println("        [-internable <internable-fields-properties-files> [...]]");
    }

    protected abstract void printUsage();

    public static void cli(AbstractZapidocFacade facade, String[] args) {
        CliParser parser = new CliParser(facade.getClass());
        try {
            CommandBinding binding = parser.parse(args);
            binding.execute((Object)facade);
            System.exit(0);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            System.err.println();
            facade.printUsage();
            System.exit(1);
        }
    }
}

