/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.zapi.generator;

import com.netapp.nmsdk.common.util.StringUtils;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.WordUtils;

public class GeneratorUtils {
    private GeneratorUtils() {
    }

    public static String zapiToUpperCamelCase(String s) {
        if (s == null) {
            return null;
        }
        return WordUtils.capitalizeFully(s, new char[]{'-', ' ', '_'}).replaceAll("[_ -]", "");
    }

    public static String zapiToLowerCamelCase(String s) {
        if (s == null) {
            return null;
        }
        return StringUtils.initialLowerCase(GeneratorUtils.zapiToUpperCamelCase(s));
    }

    public static String removeDashes(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("-", "");
    }

    public static Properties parsePropertyArgs(List<String> propertyArgs) {
        Properties generationProperties = new Properties();
        for (String property : propertyArgs) {
            String pairString = property.substring(property.indexOf(80) + 1, property.length());
            String[] pairSplit = pairString.split("=");
            if (pairSplit.length != 2) {
                throw new IllegalArgumentException(property);
            }
            String value = pairSplit[1].replaceAll("\"", "");
            if (value.trim().isEmpty()) {
                throw new IllegalArgumentException("Property value is missing: " + property);
            }
            generationProperties.put(pairSplit[0], value);
        }
        return generationProperties;
    }
}

