/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.util;

import com.netapp.nmsdk.common.util.ClassUtils;
import com.netapp.nmsdk.common.util.StringUtils;
import com.netapp.nmsdk.common.util.Transformer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Transformers {
    private static final Transformer<Object, String> TO_STRING_TRANSFORMER = new ToStringTransformer();

    private Transformers() {
    }

    public static <S, T> Transformer<S, T> fieldTransformer(Class<S> objClass, Class<T> fieldClass, Field field) {
        return new FieldTransformer<S, T>(objClass, fieldClass, field);
    }

    public static <S, T> Transformer<S, T> fieldTransformer(Class<S> objClass, Class<T> fieldClass, String fieldName) {
        Field f = Transformers.findField(objClass, fieldClass, fieldName);
        if (f != null) {
            return Transformers.fieldTransformer(objClass, fieldClass, f);
        }
        throw new UnsupportedOperationException(fieldName);
    }

    public static <S, T> Transformer<S, T> methodTransformer(Class<S> objClass, Class<T> returnClass, Method method, Object ... args) {
        return new MethodTransformer<S, T>(objClass, returnClass, method, args);
    }

    public static <S, T> Transformer<S, T> methodTransformer(Class<S> objClass, Class<T> returnClass, String methodName) {
        Method method = Transformers.findMethod(objClass, returnClass, methodName);
        if (method != null) {
            return Transformers.methodTransformer(objClass, returnClass, method, new Object[0]);
        }
        throw new UnsupportedOperationException(methodName);
    }

    public static <S, T> Transformer<S, T> propertyTransformer(Class<S> objClass, Class<T> propertyClass, String propertyName) {
        String methodSuffix = StringUtils.initialUpperCase(propertyName);
        Method getter = Transformers.findMethod(objClass, propertyClass, "get" + methodSuffix);
        if (getter == null && propertyClass.equals(Boolean.class)) {
            getter = Transformers.findMethod(objClass, propertyClass, "is" + methodSuffix);
        }
        if (getter != null) {
            return Transformers.methodTransformer(objClass, propertyClass, getter, new Object[0]);
        }
        Field field = Transformers.findField(objClass, propertyClass, propertyName);
        if (field != null) {
            return Transformers.fieldTransformer(objClass, propertyClass, field);
        }
        throw new UnsupportedOperationException(propertyName);
    }

    public static Transformer<Object, String> toStringTransformer() {
        return TO_STRING_TRANSFORMER;
    }

    private static Method findMethod(Class<?> clazz, Class<?> type, String name) {
        while (clazz != null) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equals(name) || Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length != 0 || !ClassUtils.typeAssignableFrom(type, m.getReturnType())) continue;
                return m;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private static Field findField(Class<?> clazz, Class<?> type, String name) {
        while (clazz != null) {
            for (Field f : clazz.getDeclaredFields()) {
                if (!f.getName().equals(name) || Modifier.isStatic(f.getModifiers()) || !ClassUtils.typeAssignableFrom(type, f.getType())) continue;
                return f;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private static class ToStringTransformer
    implements Transformer<Object, String> {
        private ToStringTransformer() {
        }

        @Override
        public String transform(Object arg0) {
            return arg0.toString();
        }
    }

    private static class FieldTransformer<S, T>
    implements Transformer<S, T> {
        private final Field field;
        private final Class<T> returnClass;

        public FieldTransformer(Class<S> objClass, Class<T> returnClass, Field field) {
            assert (ClassUtils.typeAssignableFrom(returnClass, field.getType()));
            this.field = field;
            this.returnClass = returnClass;
            this.field.setAccessible(true);
        }

        @Override
        public T transform(S arg0) {
            try {
                return this.returnClass.cast(this.field.get(arg0));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class MethodTransformer<S, T>
    implements Transformer<S, T> {
        private final Method method;
        private final Class<T> returnClass;
        private final Object[] args;

        public MethodTransformer(Class<S> objClass, Class<T> returnClass, Method method, Object ... args) {
            assert (ClassUtils.typeAssignableFrom(returnClass, method.getReturnType()));
            assert (method.getParameterTypes().length == args.length);
            this.method = method;
            this.returnClass = returnClass;
            this.args = args;
            this.method.setAccessible(true);
        }

        @Override
        public T transform(S arg0) {
            try {
                return this.returnClass.cast(this.method.invoke(arg0, this.args));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

