/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.util;

import com.netapp.nmsdk.common.logging.NALogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtils {
    private static final NALogger logger = NALogger.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static boolean waitForFileToAppear(File file, long timeoutInMillis) {
        if (!file.exists()) {
            long startTime = System.currentTimeMillis();
            while (!file.exists() && System.currentTimeMillis() - startTime < timeoutInMillis) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        return file.exists();
    }

    public static void echo(File file, String ... content) throws IOException {
        FileUtils.echo(file, false, content);
    }

    public static void echo(File file, boolean append, String ... content) throws IOException {
        PrintStream stream = new PrintStream(new FileOutputStream(file, append));
        for (String line : content) {
            stream.println(line);
        }
        stream.close();
    }

    public static File createTempFile(String prefix, String ... content) throws IOException {
        File file = File.createTempFile(prefix, "tmp");
        file.deleteOnExit();
        FileUtils.echo(file, content);
        return file;
    }

    public static Matcher matchLine(Pattern pattern, File file) throws IOException {
        List<Matcher> result = FileUtils.matchLines(pattern, file, 1);
        if (!result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    public static List<Matcher> matchLines(Pattern pattern, File file) throws IOException {
        return FileUtils.matchLines(pattern, file, 0);
    }

    public static List<Matcher> matchLines(Pattern pattern, File file, int maxResults) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        ArrayList<Matcher> results = new ArrayList<Matcher>();
        String line = in.readLine();
        while (line != null) {
            Matcher m = pattern.matcher(line);
            if (m.matches()) {
                results.add(m);
                if (results.size() == maxResults) break;
            }
            line = in.readLine();
        }
        in.close();
        return results;
    }

    public static File getCanonicalFile(File file) {
        file = file.getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }
}

