/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.util;

import com.netapp.nmsdk.common.logging.NALogger;
import com.netapp.nmsdk.common.util.ConfigBundle;
import com.netapp.nmsdk.common.util.ConfigProperty;
import com.netapp.nmsdk.common.util.Pollee;
import org.apache.commons.lang.time.DurationFormatUtils;

public class AdaptivePoller {
    public static final ConfigProperty<Long> PROPERTY_MIN_SLEEP_TIME_IN_MILLIS = ConfigProperty.longProperty("poller.minSleepTimeInMillis", 1000L);
    public static final ConfigProperty<Long> PROPERTY_MAX_SLEEP_TIME_IN_MILLIS = ConfigProperty.longProperty("poller.maxSleepTimeInMillis", 30000L);
    public static final ConfigProperty<Double> PROPERTY_BACKOFF_FACTOR = new ConfigProperty<Double>(Double.class, "poller.backoffFactor", 1.03);
    private static final NALogger logger = NALogger.getLogger(AdaptivePoller.class);
    private final long minSleepTimeInMillis;
    private final long maxSleepTimeInMillis;
    private final double backoffFactor;

    public AdaptivePoller(ConfigBundle configBundle) {
        this(PROPERTY_MIN_SLEEP_TIME_IN_MILLIS.lookup(configBundle), PROPERTY_MAX_SLEEP_TIME_IN_MILLIS.lookup(configBundle), PROPERTY_BACKOFF_FACTOR.lookup(configBundle));
    }

    public AdaptivePoller(long sleepTimeInMillis) {
        this(sleepTimeInMillis, sleepTimeInMillis, 1.0);
    }

    public AdaptivePoller(long minSleepTimeInMillis, long maxSleepTimeInMillis, double backoffFactor) {
        if (minSleepTimeInMillis <= 0L) {
            throw new IllegalArgumentException(String.format("minSleepTimeInMillis (%d) must be greater than 0", minSleepTimeInMillis));
        }
        if (maxSleepTimeInMillis < minSleepTimeInMillis) {
            throw new IllegalArgumentException(String.format("maxSleepTimeInMillis (%d) must be greater than minSleepTimeInMillis (%d)", maxSleepTimeInMillis, minSleepTimeInMillis));
        }
        if (backoffFactor < 1.0) {
            throw new IllegalArgumentException(String.format("backoffFactor (%f) must be greater than 1", backoffFactor));
        }
        this.minSleepTimeInMillis = minSleepTimeInMillis;
        this.maxSleepTimeInMillis = maxSleepTimeInMillis;
        this.backoffFactor = backoffFactor;
    }

    public void poll(Pollee pollee) {
        long sleepTime = this.minSleepTimeInMillis;
        while (!pollee.isComplete()) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            sleepTime = Math.min(this.maxSleepTimeInMillis, (long)((double)sleepTime * this.backoffFactor));
            logger.internal("Polling status for job [%s] (adaptive poll interval at %s)...", pollee, DurationFormatUtils.formatDurationHMS(sleepTime));
        }
        logger.internal("Finished polling for job [%s]", pollee);
    }
}

