/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.logging;

import com.netapp.nmsdk.common.logging.LogAdapter;
import com.netapp.nmsdk.common.logging.LogLevel;
import com.netapp.nmsdk.common.logging.LogMessage;
import org.slf4j.Logger;

public class SLF4JLoggerAdapter
implements LogAdapter {
    private final Logger logger;

    SLF4JLoggerAdapter(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void log(LogMessage msg) {
        this.dispatch(msg.getLevel(), msg.localizedMessage());
    }

    @Override
    public void log(LogMessage msg, Throwable t) {
        this.dispatch(msg.getLevel(), msg.localizedMessage(), t);
    }

    @Override
    public void log(LogLevel level, String msg) {
        this.dispatch(level, msg);
    }

    @Override
    public void log(LogLevel level, String msg, Throwable t) {
        this.dispatch(level, msg, t);
    }

    private void dispatch(LogLevel level, String msg) {
        switch (level) {
            case FATAL: 
            case ERROR: {
                this.logger.error(msg);
                break;
            }
            case WARN: {
                this.logger.warn(msg);
                break;
            }
            case INFO: 
            case PROGRESS: {
                this.logger.info(msg);
                break;
            }
            case DEBUG: {
                this.logger.debug(msg);
                break;
            }
            case TRACE: {
                this.logger.trace(msg);
            }
        }
    }

    private void dispatch(LogLevel level, String msg, Throwable t) {
        switch (level) {
            case FATAL: 
            case ERROR: {
                this.logger.error(msg, t);
                break;
            }
            case WARN: {
                this.logger.warn(msg, t);
                break;
            }
            case INFO: 
            case PROGRESS: {
                this.logger.info(msg, t);
                break;
            }
            case DEBUG: {
                this.logger.debug(msg, t);
                break;
            }
            case TRACE: {
                this.logger.trace(msg, t);
            }
        }
    }

    @Override
    public final boolean isLogLevelEnabled(LogLevel level) {
        switch (level) {
            case FATAL: 
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
            case WARN: {
                return this.logger.isWarnEnabled();
            }
            case INFO: 
            case PROGRESS: {
                return this.logger.isInfoEnabled();
            }
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case TRACE: {
                return this.logger.isTraceEnabled();
            }
        }
        return true;
    }
}

