/*
 * Decompiled with CFR 0.152.
 */
package netapp.manage;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import netapp.manage.NaAPIFailedException;
import netapp.manage.NaAuthenticationException;
import netapp.manage.NaElement;
import netapp.manage.NaError;
import netapp.manage.NaInvokable;
import netapp.manage.NaParser;
import netapp.manage.NaProtocolException;
import netapp.manage.http.AuthInfo;
import netapp.manage.http.HTTPClient;
import netapp.manage.http.HTTPException;
import netapp.manage.http.HTTPRequest;
import netapp.manage.http.HTTPResponse;
import org.xml.sax.SAXException;

public class NaServer {
    public static final int SERVER_TYPE_FILER = 1;
    public static final int SERVER_TYPE_NETCACHE = 2;
    public static final int SERVER_TYPE_AGENT = 3;
    public static final int SERVER_TYPE_DFM = 4;
    public static final int SERVER_TYPE_OCUM = 5;
    public static final int TRANSPORT_TYPE_HTTP = 1;
    public static final int TRANSPORT_TYPE_HTTPS = 2;
    private static final int TCP_PORT_FILER = 80;
    private static final int TCP_PORT_NETCACHE = 80;
    private static final int TCP_PORT_AGENT = 4092;
    private static final int TCP_PORT_DFM = 8088;
    private static final int TCP_PORT_OCUM = 443;
    public static final int STYLE_LOGIN_PASSWORD = 1;
    public static final int STYLE_HOSTSEQUIV = 2;
    public static final int STYLE_RPC = 3;
    public static final int STYLE_CERTIFICATE = 4;
    public static final int KEYSTORE_TYPE_JKS = 1;
    public static final int KEYSTORE_TYPE_PKCS12 = 2;
    public static final int LOGIN_PASSWORD = 1;
    public static final int HOSTSEQUIV = 2;
    private static final String FILER_REQUEST_URI = "/servlets/netapp.servlets.admin.XMLrequest_filer";
    private static final String NETCACHE_REQUEST_URI = "/servlets/netapp.servlets.admin.XMLrequest";
    private static final String AGENT_REQUEST_URI = "/apis/XMLrequest";
    private static final String DFM_REQUEST_URI = "/apis/XMLrequest";
    private static final String FILER_XML_REQUEST = "<?xml version='1.0' encoding='utf-8' ?>\r\n<!DOCTYPE netapp SYSTEM 'file:/etc/netapp_filer.dtd'>\r\n";
    private static final String AGENT_XML_REQUEST = "<?xml version='1.0' encoding='utf-8' ?>\r\n<!DOCTYPE netapp SYSTEM 'file:/etc/netapp_agent.dtd'>\r\n";
    private static final String DFM_XML_REQUEST = "<?xml version='1.0' encoding='utf-8' ?>\r\n<!DOCTYPE netapp SYSTEM 'file:/etc/netapp_dfm.dtd'>\r\n";
    private static final String FILER_NAMESPACE = "http://www.netapp.com/filer/admin";
    private static final String NMSDK_VERSION = "5.4";
    private static final String NMSDK_LANGUAGE = "Java";
    private static String NMSDK_PLATFORM = NaServer.getPlatformInfo();
    private static String nmsdkAppName = null;
    private InetAddress _server;
    private String _serverName;
    private int _type;
    private int _transport;
    private String _login;
    private String _password;
    private int _style;
    private int _port;
    private int _major;
    private int _minor;
    private int _snoop;
    private int _debugStyle;
    private boolean _keepAlive;
    private List _sessions;
    private Thread _watcherThread;
    private String _vfiler;
    private String _rawXMLOutput = null;
    private int _timeOut;
    private String cookieValue;
    private AuthInfo _authInfo;
    private boolean _useTLS = true;
    private boolean _useSSL = false;
    private static Hashtable _tlsInUse = new Hashtable();
    private boolean multipleApis = false;
    private boolean apiAttributeSet = false;

    public NaServer(InetAddress inetAddress) {
        this._server = inetAddress;
        this._serverName = inetAddress.getHostName();
        this._major = 1;
        this._minor = 0;
        this._login = null;
        this._password = null;
        this._type = 1;
        this._transport = 1;
        this._style = 1;
        this._port = 0;
        this._snoop = 0;
        this._keepAlive = false;
        this._sessions = new ArrayList();
        this._watcherThread = null;
        this._vfiler = null;
        this._debugStyle = 0;
        this._rawXMLOutput = null;
        this._timeOut = 0;
        this._authInfo = new AuthInfo(this._serverName);
    }

    public NaServer(String string) throws UnknownHostException {
        this._serverName = string;
        this._major = 1;
        this._minor = 0;
        this._login = null;
        this._password = null;
        this._type = 1;
        this._transport = 1;
        this._style = 1;
        this._port = 0;
        this._snoop = 0;
        this._keepAlive = false;
        this._sessions = new ArrayList();
        this._watcherThread = null;
        this._vfiler = null;
        this._debugStyle = 0;
        this._rawXMLOutput = null;
        this._timeOut = 0;
        this._authInfo = new AuthInfo(this._serverName);
    }

    public NaServer(InetAddress inetAddress, int n, int n2) {
        this(inetAddress);
        this.setApiVersion(n, n2);
    }

    public NaServer(String string, int n, int n2) throws UnknownHostException {
        this._serverName = string;
        this._login = null;
        this._password = null;
        this._type = 1;
        this._transport = 1;
        this._style = 1;
        this._port = 0;
        this._snoop = 0;
        this._keepAlive = false;
        this._sessions = new ArrayList();
        this._watcherThread = null;
        this._vfiler = null;
        this.setApiVersion(n, n2);
        this._debugStyle = 0;
        this._rawXMLOutput = null;
        this._timeOut = 0;
        this._authInfo = new AuthInfo(this._serverName);
    }

    public void setApiVersion(int n, int n2) {
        this._major = n;
        this._minor = n2;
    }

    public synchronized void close() {
        this.setKeepAliveEnabled(false);
        if (null != this._watcherThread) {
            this._watcherThread.interrupt();
        }
    }

    public synchronized void setKeepAliveEnabled(boolean bl) {
        if (!bl) {
            Iterator iterator = this._sessions.iterator();
            while (iterator.hasNext()) {
                HTTPClient hTTPClient = (HTTPClient)iterator.next();
                iterator.remove();
                hTTPClient.close();
            }
            this._keepAlive = false;
        } else {
            this._keepAlive = true;
        }
    }

    private synchronized void cleanSessionCache() {
        boolean bl = 2 == this._transport;
        Iterator iterator = this._sessions.iterator();
        while (iterator.hasNext()) {
            HTTPClient hTTPClient = (HTTPClient)iterator.next();
            if (hTTPClient.isCompatible(bl, this._server, this.getPort(), this._authInfo, this._useTLS) && !hTTPClient.isTimedOut()) continue;
            iterator.remove();
            hTTPClient.close();
        }
        if (0 == this._sessions.size()) {
            this._watcherThread = null;
        }
    }

    private synchronized HTTPClient getSession() throws IOException {
        boolean bl;
        boolean bl2 = 2 == this._transport;
        boolean bl3 = bl = 2 == this._style;
        if (this._server == null) {
            try {
                this._server = InetAddress.getByName(this._serverName);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IOException("The host " + this._serverName + "could not be resolved");
            }
        }
        while (this._sessions.size() > 0) {
            HTTPClient hTTPClient = (HTTPClient)this._sessions.remove(0);
            if (!hTTPClient.isTimedOut() && hTTPClient.isCompatible(bl2, this._server, this.getPort(), this._authInfo, this._useTLS)) {
                return hTTPClient;
            }
            hTTPClient.close();
        }
        return new HTTPClient(bl2, this._server, this.getPort(), bl, this._timeOut, this._authInfo, this._useTLS, this._useSSL);
    }

    private synchronized void cacheSession(HTTPClient hTTPClient) {
        this._sessions.add(hTTPClient);
        if (null == this._watcherThread) {
            this._watcherThread = new Thread(new Runnable(){

                public void run() {
                    Thread thread = Thread.currentThread();
                    while (NaServer.this._watcherThread == thread) {
                        NaServer.this.cleanSessionCache();
                        if (NaServer.this._watcherThread != thread) break;
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
        }
    }

    public synchronized void setPort(int n) {
        this._port = n;
    }

    public int getPort() {
        if (0 != this._port) {
            return this._port;
        }
        switch (this._type) {
            case 2: {
                return 80;
            }
            case 3: {
                return 4092;
            }
            case 4: {
                return 8088;
            }
            case 5: {
                return 443;
            }
        }
        return 80;
    }

    public synchronized void setTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid timeout value: " + n);
        }
        this._timeOut = n;
    }

    public int getTimeout() {
        return this._timeOut;
    }

    public int getServerType() {
        return this._type;
    }

    private String getURISuffix() {
        switch (this._type) {
            case 2: {
                return NETCACHE_REQUEST_URI;
            }
            case 3: {
                return "/apis/XMLrequest";
            }
            case 4: {
                return "/apis/XMLrequest";
            }
            case 5: {
                return "/apis/XMLrequest";
            }
        }
        return FILER_REQUEST_URI;
    }

    public synchronized void setServerType(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this._type = n;
                return;
            }
            case 5: {
                this._type = n;
                this._transport = 2;
                this._port = 443;
                return;
            }
        }
        throw new IllegalArgumentException("Unknown API server type: " + n);
    }

    public int getTransportType() {
        return this._transport;
    }

    public synchronized void setTransportType(int n) {
        switch (n) {
            case 1: {
                if (this._type == 5) {
                    throw new IllegalArgumentException("'SERVER_TYPE_OCUM' does not support 'TRANSPORT_TYPE_HTTP'");
                }
                this._transport = n;
                break;
            }
            case 2: {
                this._transport = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown API transport type: " + n);
            }
        }
        if (this._transport != 2) {
            this._authInfo.disableCBA();
        }
        if (this._transport == 2) {
            Boolean bl = (Boolean)_tlsInUse.get(this._serverName);
            if (bl == null) {
                bl = Boolean.TRUE;
                _tlsInUse.put(this._serverName, bl);
            }
            this._useTLS = bl;
        }
    }

    public void setAdminUser(String string, String string2) {
        this._login = string;
        this._password = string2;
    }

    public void setStyle(int n) {
        if (1 != n && 2 != n && 3 != n && 4 != n) {
            throw new IllegalArgumentException("Invalid style: " + n);
        }
        if (4 == n) {
            this.setTransportType(2);
            this._authInfo.enableCBA();
            this.enableServerCertVerification();
        } else {
            this._authInfo.disableCBA();
        }
        this._style = n;
    }

    public void setSnoop(int n) {
        this._snoop = n;
        HTTPClient.snoop = n;
    }

    public int getStyle() {
        return this._style;
    }

    public NaElement invokeElem(NaElement naElement) throws IOException, NaAuthenticationException, NaAPIFailedException, NaProtocolException {
        int n;
        NaElement naElement2;
        String string = this.invokeElemForXML(naElement);
        try {
            naElement2 = NaParser.parseTree(new StringReader(string));
        }
        catch (IOException iOException) {
            throw new NaError("I/O error during XML parsing", iOException);
        }
        catch (SAXException sAXException) {
            throw new NaProtocolException("Malformed XML", sAXException);
        }
        if (null == naElement2 || !naElement2.getName().equals("netapp")) {
            throw new NaProtocolException("Output from server doesn't contain <netapp> element.");
        }
        if (naElement2.getChildren().size() > 1 && (naElement2.getChildren().size() != 2 || naElement2.getChildByName("trace-output") == null)) {
            return naElement2;
        }
        NaElement naElement3 = naElement2.getChildByName("results");
        if ("passed".equals(naElement3.getAttr("status"))) {
            return naElement3;
        }
        String string2 = naElement3.getAttr("errno");
        if (null == string2) {
            n = 13114;
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NaProtocolException("Malformed errno code: " + string2, numberFormatException);
        }
        throw new NaAPIFailedException(n, naElement3.getAttr("reason"));
    }

    public String invokeElemForXML(NaElement naElement) throws IOException, NaAuthenticationException, NaAPIFailedException, NaProtocolException {
        if (naElement.getName().equals("netapp")) {
            this.multipleApis = true;
            if (naElement.getAttr("version") != null && naElement.getAttr("xmlns") != null) {
                this.apiAttributeSet = true;
            }
        }
        String string = naElement.toString();
        String string2 = 3 == this._style ? this.invokeRPC(string) : this.invokeHTTP(string);
        if (this._snoop == -1) {
            this.setRawXMLOutput(string2);
            System.out.println("OUTPUT:\n" + string2);
        }
        if (this._snoop > 1) {
            System.err.println("BODY =====\n" + string2 + "\n===== END BODY");
        }
        if (0 == string2.length()) {
            throw new NaProtocolException("body of server response empty");
        }
        int n = string2.indexOf("<!DOCTYPE");
        int n2 = string2.indexOf("<netapp");
        if (n < 0) {
            throw new NaProtocolException("server response did not contain <!DOCTYPE>");
        }
        if (n2 < 0) {
            n2 = string2.indexOf("<", n);
            if (n2 < 0) {
                throw new NaProtocolException("Output from server doesn't contain <netapp> element.");
            }
            throw new NaProtocolException("Unexpected tag found: " + string2.substring(0, n) + string2.substring(n2));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2.substring(0, n)).append(string2.substring(n2));
        if (this._snoop > 1) {
            System.err.println("MODIFIED BODY =====\n" + stringBuffer.toString() + "\n===== END MODIFIED BODY");
        }
        return stringBuffer.toString();
    }

    private String invokeHTTP(String string) throws IOException, NaAuthenticationException, NaProtocolException {
        HTTPResponse hTTPResponse;
        HTTPClient hTTPClient;
        byte[] byArray;
        String string2 = null;
        HTTPRequest hTTPRequest = new HTTPRequest(2, this.getURISuffix(), 1);
        String string3 = "";
        if (this._vfiler != null) {
            string3 = " vfiler='" + this._vfiler + "'";
        }
        String string4 = "";
        if (nmsdkAppName != null) {
            string4 = " nmsdk_app='" + nmsdkAppName + "'";
        }
        try {
            switch (this._type) {
                case 4: {
                    string2 = DFM_XML_REQUEST;
                    break;
                }
                case 5: {
                    string2 = DFM_XML_REQUEST;
                    break;
                }
                case 3: {
                    string2 = AGENT_XML_REQUEST;
                    break;
                }
                case 1: {
                    string2 = FILER_XML_REQUEST;
                }
            }
            if (this.apiAttributeSet) {
                byArray = (string2 + string + "\r\n").getBytes("UTF-8");
            } else {
                if (this.multipleApis) {
                    string = string.replaceFirst("<netapp>", "");
                    string = string.replaceAll("</netapp>", "");
                }
                byArray = (string2 + "<netapp version='" + this._major + "." + this._minor + "' xmlns='" + FILER_NAMESPACE + "'" + string3 + " nmsdk_version='" + NMSDK_VERSION + "'" + " nmsdk_platform='" + NMSDK_PLATFORM + "'" + " nmsdk_language='" + NMSDK_LANGUAGE + "'" + string4 + ">" + string + "</netapp>\r\n").getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NaError("Failed UTF-8 encoding", unsupportedEncodingException);
        }
        if (this._snoop == -1) {
            System.out.println("INPUT:\n" + string2 + "<netapp" + string3 + " xmlns='" + FILER_NAMESPACE + " ' " + " version='" + this._major + "." + this._minor + "'" + " nmsdk_version='" + NMSDK_VERSION + "'" + " nmsdk_platform='" + NMSDK_PLATFORM + "'" + " nmsdk_language='" + NMSDK_LANGUAGE + "'" + string4 + ">" + string + "</netapp>\r\n");
        }
        hTTPRequest.setContents(byArray);
        if (this.cookieValue != null) {
            hTTPRequest.setHeader("Cookie", this.cookieValue);
        }
        hTTPRequest.setHeader("Content-Length", "" + byArray.length);
        if (this._style != 2) {
            hTTPRequest.setBasicAuthorization(this._login, this._password);
        }
        if (this._keepAlive) {
            hTTPRequest.setHeader("Connection", "Keep-Alive");
        }
        while (true) {
            boolean bl;
            boolean bl2 = bl = 0 == (hTTPClient = this.getSession()).getUseCount();
            if (this._snoop > 0) {
                System.err.println(bl ? "*** Using new connection" : "*** Reusing existing connection");
            }
            try {
                hTTPResponse = hTTPClient.doRequest(hTTPRequest);
            }
            catch (IOException iOException) {
                String string5;
                hTTPClient.close();
                if (this._useTLS && this._useSSL && iOException.getCause() instanceof SSLException && (string5 = iOException.getMessage()) != null && string5.indexOf("bad_record_mac") != -1) {
                    _tlsInUse.put(this._serverName, Boolean.FALSE);
                    this._useTLS = false;
                    if (this._snoop <= 0) continue;
                    System.err.println("*** Failed TLS attempt for server " + this._serverName + ", trying SSLv3 ..");
                    continue;
                }
                if (bl) {
                    throw iOException;
                }
                if (this._snoop <= 0) continue;
                System.err.println("*** Failed attempt (" + iOException + ") trying again");
                continue;
            }
            catch (HTTPException hTTPException) {
                hTTPClient.close();
                throw new NaProtocolException("HTTP protocol error", hTTPException);
            }
            break;
        }
        if (this._keepAlive && hTTPResponse.canKeepAlive()) {
            if (this._snoop > 0) {
                System.err.println("*** Saving connection for future use");
            }
            this.cacheSession(hTTPClient);
        } else {
            if (this._snoop > 0) {
                System.err.println("*** Closing non-reusable connection");
            }
            hTTPClient.close();
        }
        if (401 == hTTPResponse.getStatusCode()) {
            throw new NaAuthenticationException("Authorization failed");
        }
        if (200 != hTTPResponse.getStatusCode()) {
            throw new NaProtocolException("Unexpected HTTP response: " + hTTPResponse.getStatusCode() + " " + hTTPResponse.getReasonPhrase());
        }
        try {
            return new String(hTTPResponse.getContents(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NaError("Failed UTF-8 decoding", unsupportedEncodingException);
        }
    }

    public NaElement getXMLParseInput(String string) throws IOException, SAXException, NaProtocolException {
        NaElement naElement;
        boolean bl = false;
        try {
            naElement = NaParser.parseTree(new StringReader(string));
        }
        catch (IOException iOException) {
            throw new NaError("I/O error during XML parsing", iOException);
        }
        catch (SAXException sAXException) {
            throw new NaProtocolException("Malformed XML", sAXException);
        }
        return naElement;
    }

    private void setRawXMLOutput(String string) {
        this._rawXMLOutput = string;
    }

    private String invokeRPC(String string) throws IOException, NaAuthenticationException, NaProtocolException {
        NaInvokable naInvokable;
        try {
            Class<?> clazz = Class.forName("netapp.manage.NaRPCTarget");
            naInvokable = (NaInvokable)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NaError("Failed to load RPC library", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new NaError("Failed to instantiate RPC library", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NaError("Illegal access loading RPC library", illegalAccessException);
        }
        naInvokable.setHostname(this._serverName);
        string = "<netapp version='" + this._major + "." + this._minor + "' xmlns='" + FILER_NAMESPACE + "'>" + string + "</netapp>\r\n";
        return naInvokable.invoke(string);
    }

    private String getTransportString() {
        switch (this._transport) {
            case 1: {
                return "HTTP";
            }
            case 2: {
                return "HTTPS";
            }
        }
        return Integer.toString(this._transport);
    }

    private String getAuthStyleString() {
        switch (this._style) {
            case 1: {
                return "password";
            }
            case 2: {
                return "host-equiv";
            }
            case 3: {
                return "RPC";
            }
            case 4: {
                return "CERTIFICATE";
            }
        }
        return Integer.toString(this._style);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        stringBuffer.append("server=" + this._server.getHostName());
        stringBuffer.append(",");
        stringBuffer.append("uri=" + this.getURISuffix());
        stringBuffer.append(",");
        stringBuffer.append("login=" + this._login);
        stringBuffer.append(",");
        stringBuffer.append("password=(hidden)");
        stringBuffer.append(",");
        stringBuffer.append("auth-style=" + this.getAuthStyleString());
        stringBuffer.append(",");
        stringBuffer.append("protocol=" + this.getTransportString());
        stringBuffer.append(",");
        stringBuffer.append("port=" + this.getPort());
        stringBuffer.append(",");
        stringBuffer.append("version=" + this._major + "." + this._minor);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public synchronized void setVfilerTunneling(String string) {
        if (this._major >= 1 && this._minor >= 7) {
            this._vfiler = string;
            return;
        }
        throw new IllegalArgumentException("ONTAPI version must be at least 1.7 to send API to a vfiler");
    }

    public void setCookie(String string) {
        this.cookieValue = string;
    }

    public String getCookie() {
        return this.cookieValue;
    }

    public synchronized void setVserver(String string) {
        if (string == null) {
            throw new NullPointerException("vserver name must not be null");
        }
        if (this._major >= 1 && this._minor >= 15) {
            this._vfiler = string;
            return;
        }
        throw new IllegalArgumentException("ONTAPI version must be at least 1.15 to send API to a vserver");
    }

    public synchronized String getVserver() {
        return this._vfiler;
    }

    public void setKeyStore(String string, String string2) {
        this.setKeyStore(string, string2, null);
    }

    public void setKeyStore(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("KeyStore file cannot be null");
        }
        this._authInfo.setKeyStore(string, string2, string3);
    }

    public void setKeyStoreType(int n) {
        switch (n) {
            case 1: {
                this._authInfo.setKeyStoreType("JKS");
                break;
            }
            case 2: {
                this._authInfo.setKeyStoreType("PKCS12");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid keystore type: " + n);
            }
        }
    }

    public void enableServerCertVerification() {
        if (this._transport != 2) {
            throw new IllegalStateException("Server certificate verification can only be enabled for HTTPS transport");
        }
        this._authInfo.enableServerCertVerification();
    }

    public void disableServerCertVerification() {
        if (this._transport != 2) {
            throw new IllegalStateException("Server certificate verification can only be disabled for HTTPS transport");
        }
        this._authInfo.disableServerCertVerification();
    }

    public boolean isServerCertVerificationEnabled() {
        return this._authInfo.isServerCertVerificationEnabled();
    }

    public void enableHostnameVerification() {
        if (!this._authInfo.isServerCertVerificationEnabled()) {
            throw new IllegalStateException("Server certificate verification is not enabled");
        }
        this._authInfo.enableHostnameVerification();
    }

    public void disableHostnameVerification() {
        if (!this._authInfo.isServerCertVerificationEnabled()) {
            throw new IllegalStateException("Server certificate verification is not enabled");
        }
        this._authInfo.disableHostnameVerification();
    }

    public boolean isHostnameVerificationEnabled() {
        return this._authInfo.isHostnameVerificationEnabled();
    }

    public void setTrustStore(String string) {
        if (string == null) {
            throw new IllegalArgumentException("TrustStore file cannot be null");
        }
        this._authInfo.setTrustStore(string);
    }

    public void enableTLS() {
        if (this._transport != 2) {
            throw new IllegalStateException("TLS protocol can only be enabled for HTTPS transport");
        }
        this._useTLS = true;
    }

    public void disableTLS() {
        if (this._transport != 2) {
            throw new IllegalStateException("TLS protocol can only be disabled for HTTPS transport");
        }
        this._useTLS = false;
    }

    public boolean isTLSEnabled() {
        return this._useTLS;
    }

    public void enableSSLv3() {
        if (this._transport != 2) {
            throw new IllegalStateException("SSL protocol can only be disabled for HTTPS transport");
        }
        this._useSSL = true;
    }

    public void disableSSLv3() {
        if (this._transport != 2) {
            throw new IllegalStateException("SSL protocol can only be disabled for HTTPS transport");
        }
        this._useSSL = false;
    }

    public boolean isSSLv3Enabled() {
        return this._useSSL;
    }

    public static void setApplicationName(String string) {
        nmsdkAppName = string;
    }

    public static String getApplicationName() {
        return nmsdkAppName;
    }

    private static String getPlatformInfo() {
        String string = System.getProperty("os.name");
        String string2 = "";
        if (string.startsWith("Windows")) {
            return NaServer.getWindowsPlatformInfo();
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            String string3 = "";
            String string4 = "";
            if (string.equals("Linux")) {
                File file = new File("/etc/SuSE-release");
                String[] stringArray = file.exists() ? new String[]{"sh", "-c", "head -n 1 /etc/SuSE-release && uname -p"} : new String[]{"sh", "-c", "head -n 1 /etc/issue && uname -p"};
                Process process = runtime.exec(stringArray);
                process.waitFor();
                if (process.exitValue() != 0) {
                    return string;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                string3 = bufferedReader.readLine();
                string4 = bufferedReader.readLine();
                bufferedReader.close();
                String string5 = "(.*?) \\(.*?\\)";
                Pattern pattern = Pattern.compile(string5);
                Matcher matcher = pattern.matcher(string3);
                if (matcher.find()) {
                    string3 = matcher.group(1);
                }
                string2 = string3 + " " + string4;
            } else if (string.equals("SunOS")) {
                String[] stringArray = new String[]{"sh", "-c", "uname -srp && isainfo -b"};
                Process process = runtime.exec(stringArray);
                process.waitFor();
                if (process.exitValue() != 0) {
                    return string;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string6 = bufferedReader.readLine();
                String string7 = bufferedReader.readLine() + "-bit";
                string2 = string6 + " " + string7;
                bufferedReader.close();
            } else if (string.equals("HP-UX")) {
                String[] stringArray = new String[]{"sh", "-c", "uname -srm"};
                Process process = runtime.exec(stringArray);
                process.waitFor();
                if (process.exitValue() != 0) {
                    return string;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                string2 = bufferedReader.readLine();
                bufferedReader.close();
            } else if (string.equals("AIX")) {
                String[] stringArray = new String[]{"sh", "-c", "uname -sp && oslevel && getconf KERNEL_BITMODE"};
                Process process = runtime.exec(stringArray);
                process.waitFor();
                if (process.exitValue() != 0) {
                    return string;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string8 = bufferedReader.readLine();
                String string9 = bufferedReader.readLine();
                String string10 = bufferedReader.readLine();
                bufferedReader.close();
                String[] stringArray2 = string8.split("\\s+");
                string3 = stringArray2[0];
                string4 = stringArray2[1];
                string2 = string3 + " " + string9 + " " + string4 + " " + string10 + "-bit";
            } else {
                string2 = string;
            }
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    private static String getWindowsPlatformInfo() {
        String string;
        String string2 = NaServer.getWindowsRegistryValue("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "ProductName");
        String string3 = string2 != null ? ((string = NaServer.getWindowsRegistryValue("SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment", "PROCESSOR_ARCHITECTURE")) != null ? string2 + " " + string : string2) : System.getProperty("os.name");
        return string3;
    }

    private static String getWindowsRegistryValue(String string, String string2) {
        byte[] byArray = null;
        Integer n = new Integer(-2147483646);
        Integer n2 = new Integer(131097);
        try {
            Class<?> clazz = Preferences.userRoot().getClass();
            Class[] classArray = new Class[]{Integer.TYPE, [B.class, Integer.TYPE};
            Class[] classArray2 = new Class[]{Integer.TYPE};
            Class[] classArray3 = new Class[]{Integer.TYPE, [B.class};
            Method method = clazz.getDeclaredMethod("WindowsRegOpenKey", classArray);
            Method method2 = clazz.getDeclaredMethod("WindowsRegCloseKey", classArray2);
            Method method3 = clazz.getDeclaredMethod("WindowsRegQueryValueEx", classArray3);
            method.setAccessible(true);
            method3.setAccessible(true);
            method2.setAccessible(true);
            Object[] objectArray = new Object[]{n, NaServer.stringToByteArray(string), n2};
            int[] nArray = (int[])method.invoke(null, objectArray);
            if (nArray[1] != 0) {
                return null;
            }
            Integer n3 = new Integer(nArray[0]);
            Object[] objectArray2 = new Object[]{n3, NaServer.stringToByteArray(string2)};
            byArray = (byte[])method3.invoke(null, objectArray2);
            Object[] objectArray3 = new Object[]{n3};
            method2.invoke(null, objectArray3);
            if (byArray == null) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return new String(byArray).trim();
    }

    private static byte[] stringToByteArray(String string) {
        byte[] byArray = new byte[string.length() + 1];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        byArray[string.length()] = 0;
        return byArray;
    }
}

