/*
 * Decompiled with CFR 0.152.
 */
package zexplore.toolbar;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;
import util.TreeUtil;
import zexplore.IconMap;
import zexplore.KeyOperationsListener;
import zexplore.Server;
import zexplore.View;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteTabPanel;
import zexplore.menubar.preferences.PreferencesMenu;

public class ExecuteButton
extends JButton {
    private static final long serialVersionUID = 6227100095517530379L;

    public ExecuteButton() {
        super(new IconMap().getIcon("execute"));
        String string = "Execute Selected Workflow on a Connected Server.";
        this.setToolTipText(string);
        this.setContentAreaFilled(false);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ExecuteButton.this.setContentAreaFilled(true);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ExecuteButton.this.setContentAreaFilled(false);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ExecuteButton.this.executeApi();
            }
        });
        this.addKeyListener(new KeyOperationsListener());
    }

    public void executeApi() {
        int n = ExecuteDevelopPane.executeTabbedPane.getSelectedIndex();
        ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n);
        String string = executeTabPanel.inputPanel.input.getText();
        if (string.trim().equals("")) {
            return;
        }
        Server server = executeTabPanel.getServer();
        if (server == null) {
            int n2 = JOptionPane.showConfirmDialog(View.frame, "Not connected to a server. \nDo you want to connect to a server?", "Not Connected", 0, 2);
            if (n2 == 0) {
                PreferencesMenu.connectItem.connect();
                server = executeTabPanel.getServer();
                if (server == null) {
                    return;
                }
            } else {
                return;
            }
        }
        String string2 = server.executeXMLApi(string);
        View.statusBar.setExecutionTime(server.getExecutionTime());
        executeTabPanel.outputTabbedPane.xmlOutputPanel.output.setText(string2);
        DefaultTreeModel defaultTreeModel = TreeUtil.getTreeModelFromXML(string2, null);
        executeTabPanel.outputTabbedPane.treeOutputPanel.outputTree.setModel(defaultTreeModel);
    }
}

