/*
 * Decompiled with CFR 0.152.
 */
package zexplore.preferences;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import zexplore.preferences.PreferenceConstant;

public class ZapiPreferences {
    private static final int pieceLength = 6144;

    public static int getInt(PreferenceConstant preferenceConstant) {
        Preferences preferences = ZapiPreferences.getPreferences();
        return preferences.getInt(preferenceConstant.toString(), (Integer)preferenceConstant.getDefaultValue());
    }

    public static String get(PreferenceConstant preferenceConstant) {
        Preferences preferences = ZapiPreferences.getPreferences();
        return preferences.get(preferenceConstant.toString(), (String)preferenceConstant.getDefaultValue());
    }

    public static boolean getBoolean(PreferenceConstant preferenceConstant) {
        Preferences preferences = ZapiPreferences.getPreferences();
        return preferences.getBoolean(preferenceConstant.toString(), (Boolean)preferenceConstant.getDefaultValue());
    }

    public static double getDouble(PreferenceConstant preferenceConstant) {
        Preferences preferences = ZapiPreferences.getPreferences();
        return preferences.getDouble(preferenceConstant.toString(), (Double)preferenceConstant.getDefaultValue());
    }

    public static long getLong(PreferenceConstant preferenceConstant) {
        Preferences preferences = ZapiPreferences.getPreferences();
        return preferences.getLong(preferenceConstant.toString(), (Long)preferenceConstant.getDefaultValue());
    }

    public static float getFloat(PreferenceConstant preferenceConstant) {
        Preferences preferences = ZapiPreferences.getPreferences();
        return preferences.getFloat(preferenceConstant.toString(), ((Float)preferenceConstant.getDefaultValue()).floatValue());
    }

    public static void putInt(PreferenceConstant preferenceConstant, int n) {
        Preferences preferences = ZapiPreferences.getPreferences();
        preferences.putInt(preferenceConstant.toString(), n);
    }

    public static void put(PreferenceConstant preferenceConstant, String string) {
        Preferences preferences = ZapiPreferences.getPreferences();
        preferences.put(preferenceConstant.toString(), string);
    }

    public static void putBoolean(PreferenceConstant preferenceConstant, boolean bl) {
        Preferences preferences = ZapiPreferences.getPreferences();
        preferences.putBoolean(preferenceConstant.toString(), bl);
    }

    public static void putDouble(PreferenceConstant preferenceConstant, double d) {
        Preferences preferences = ZapiPreferences.getPreferences();
        preferences.putDouble(preferenceConstant.toString(), d);
    }

    public static void putLong(PreferenceConstant preferenceConstant, long l) {
        Preferences preferences = ZapiPreferences.getPreferences();
        preferences.putLong(preferenceConstant.toString(), l);
    }

    public static void putFloat(PreferenceConstant preferenceConstant, float f) {
        Preferences preferences = ZapiPreferences.getPreferences();
        preferences.putFloat(preferenceConstant.toString(), f);
    }

    public static Preferences getPreferences() {
        return Preferences.userNodeForPackage(ZapiPreferences.class);
    }

    private static byte[] object2Bytes(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[][] breakIntoPieces(byte[] byArray) {
        int n = (byArray.length + 6144 - 1) / 6144;
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 6144;
            int n3 = n2 + 6144;
            if (n3 > byArray.length) {
                n3 = byArray.length;
            }
            int n4 = n3 - n2;
            byArrayArray[i] = new byte[n4];
            System.arraycopy(byArray, n2, byArrayArray[i], 0, n4);
        }
        return byArrayArray;
    }

    private static void writePieces(Preferences preferences, String string, byte[][] byArray) throws BackingStoreException {
        Preferences preferences2 = preferences.node(string);
        preferences2.clear();
        for (int i = 0; i < byArray.length; ++i) {
            preferences2.putByteArray("" + i, byArray[i]);
        }
    }

    private static byte[][] readPieces(Preferences preferences, String string) throws BackingStoreException {
        Preferences preferences2 = preferences.node(string);
        String[] stringArray = preferences2.keys();
        int n = stringArray.length;
        byte[][] byArrayArray = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byArrayArray[i] = preferences2.getByteArray("" + i, null);
        }
        return byArrayArray;
    }

    private static byte[] combinePieces(byte[][] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += byArray[i].length;
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            System.arraycopy(byArray[i], 0, byArray2, n2, byArray[i].length);
            n2 += byArray[i].length;
        }
        return byArray2;
    }

    private static Object bytes2Object(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Object object = objectInputStream.readObject();
        return object;
    }

    public static void putObject(PreferenceConstant preferenceConstant, Object object) throws IOException, BackingStoreException, ClassNotFoundException {
        Preferences preferences = ZapiPreferences.getPreferences();
        byte[] byArray = ZapiPreferences.object2Bytes(object);
        byte[][] byArray2 = ZapiPreferences.breakIntoPieces(byArray);
        ZapiPreferences.writePieces(preferences, preferenceConstant.toString(), byArray2);
    }

    public static Object getObject(PreferenceConstant preferenceConstant) throws IOException, BackingStoreException, ClassNotFoundException {
        Preferences preferences = ZapiPreferences.getPreferences();
        byte[][] byArray = ZapiPreferences.readPieces(preferences, preferenceConstant.toString());
        byte[] byArray2 = ZapiPreferences.combinePieces(byArray);
        Object object = ZapiPreferences.bytes2Object(byArray2);
        return object;
    }
}

