/*
 * Decompiled with CFR 0.152.
 */
package zexplore.menubar.preferences;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import zexplore.IconMap;
import zexplore.codegenerator.CodeGenerator;

public class LanguagesMenu
extends JMenu {
    private static final long serialVersionUID = 5630865961150704525L;
    private static Map<String, String> languageLabelMap = new HashMap<String, String>();
    private static final String[] supported_languages = new String[]{"C#", "C", "Java", "Perl", "Python", "Ruby"};
    private String selectedLanguage = supported_languages[2];
    private Icon tickIcon = new IconMap().getIcon("tick");

    public LanguagesMenu() {
        this.setText("Languages");
        this.setMnemonic(76);
        this.setIcon(new IconMap().getIcon("language"));
        this.createLanguageLabelMap();
        this.addMenuItems();
    }

    private void createLanguageLabelMap() {
        for (String string : supported_languages) {
            if (string.equals("C#")) {
                languageLabelMap.put(string, "C#                  Ctrl+Shift+H");
                continue;
            }
            if (string.equals("C")) {
                languageLabelMap.put(string, "C                     Ctrl+Shift+C");
                continue;
            }
            if (string.equals("Java")) {
                languageLabelMap.put(string, "Java               Ctrl+Shift+J");
                continue;
            }
            if (string.equals("Perl")) {
                languageLabelMap.put(string, "Perl                 Ctrl+Shift+P");
                continue;
            }
            if (string.equals("Python")) {
                languageLabelMap.put(string, "Python            Ctrl+Shift+Y");
                continue;
            }
            if (!string.equals("Ruby")) continue;
            languageLabelMap.put(string, "Ruby               Ctrl+Shift+R");
        }
    }

    private void addMenuItems() {
        for (String string : supported_languages) {
            final JMenuItem jMenuItem = new JMenuItem(languageLabelMap.get(string));
            if (string.equals(this.selectedLanguage)) {
                jMenuItem.setIcon(this.tickIcon);
            }
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String[] stringArray = jMenuItem.getText().split("\\s");
                    LanguagesMenu.this.setLanguage(stringArray[0].trim());
                }
            });
            this.add(jMenuItem);
        }
    }

    public void setLanguage(String string) {
        this.selectedLanguage = string;
        this.removeAll();
        this.addMenuItems();
        CodeGenerator.generateSampleCode();
    }

    public String getSelectedLanguage() {
        return this.selectedLanguage;
    }
}

