/*
 * Decompiled with CFR 0.152.
 */
package zexplore.menubar.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import zexplore.KeyOperationsListener;
import zexplore.Server;
import zexplore.View;
import zexplore.apiexplorer.APIExplorerPanel;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteTabPanel;

public class ConnectDialog
extends JDialog {
    private static final long serialVersionUID = -4947420065262559745L;
    private JFrame frame = View.frame;
    protected JTextComponent portField;
    protected JTextComponent vfiler;
    protected JComboBox protocolComboBox;
    protected JRadioButton ontapRadioButton;
    protected JRadioButton dfmRadioButton;
    private ButtonGroup serverTypeRadioButtonGroup;
    private JPanel radioPanel;
    private JPanel serverCredentialPanel;
    protected JTextComponent serverTextField;
    protected JTextComponent userTextField;
    protected JTextComponent passwordField;
    private JPanel connectOptionsButtonPanel;
    private JButton connectButton;
    private JButton cancelButton;
    private JToggleButton optionsButton;
    private JPanel advancedOptionsPanel;
    private JPanel advancedOptionsPanelWithEmptyBorder;
    private JPanel connectionParametersPanel;
    private JPanel vfilerTunnelingPanel;
    private JTextField timeoutTextField;
    private ConnectDialog dialog = this;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private JPanel basicParametersPanel = new JPanel();
    private final Dimension dialogBasicDim;
    private final Dimension dialogAdvancedOntapDim;
    private final Dimension dialogAdvancedDfmDim;

    public ConnectDialog() {
        super(View.frame, "Connect", true);
        this.addServerTypeRadioPanel(this.basicParametersPanel);
        this.addServerCredentialPanel(this.basicParametersPanel);
        this.addConnectOptionsButtons(this.mainPanel);
        this.addAdvancedOptionsPanel(this.mainPanel);
        this.basicParametersPanel.add(this.radioPanel);
        this.basicParametersPanel.add(this.serverCredentialPanel);
        this.mainPanel.add((Component)this.basicParametersPanel, "North");
        this.mainPanel.add((Component)this.connectOptionsButtonPanel, "South");
        this.dialog.getContentPane().add(this.mainPanel);
        this.dialog.setResizable(false);
        this.dialog.pack();
        this.dialogAdvancedOntapDim = this.dialog.getSize();
        this.dialogAdvancedDfmDim = new Dimension(this.dialog.getWidth(), this.dialog.getHeight() - this.vfilerTunnelingPanel.getHeight());
        this.dialogBasicDim = new Dimension(this.dialog.getWidth(), this.dialog.getHeight() / 2);
        this.dialog.setSize(this.dialogBasicDim);
        this.advancedOptionsPanelWithEmptyBorder.setVisible(false);
        this.dialog.setLocationRelativeTo(this.frame);
        this.dialog.setVisible(true);
        this.dialog.addKeyListener(new KeyOperationsListener(this.dialog));
    }

    private void addServerTypeRadioPanel(JPanel jPanel) {
        this.ontapRadioButton = new JRadioButton("Data ONTAP", true);
        this.ontapRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.vfilerTunnelingPanel.setVisible(true);
                ConnectDialog.this.portField.setText(Integer.toString(ConnectDialog.this.getSelectedDefaultPort()));
                if (ConnectDialog.this.optionsButton.getText().equals("Basic <<")) {
                    ConnectDialog.this.dialog.setSize(ConnectDialog.this.dialogAdvancedOntapDim);
                    ConnectDialog.this.mainPanel.updateUI();
                }
            }
        });
        this.ontapRadioButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.dfmRadioButton = new JRadioButton("DataFabric Manager server", false);
        this.dfmRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.vfilerTunnelingPanel.setVisible(false);
                ConnectDialog.this.portField.setText(Integer.toString(ConnectDialog.this.getSelectedDefaultPort()));
                if (ConnectDialog.this.optionsButton.getText().equals("Basic <<")) {
                    ConnectDialog.this.dialog.setSize(ConnectDialog.this.dialogAdvancedDfmDim);
                    ConnectDialog.this.mainPanel.updateUI();
                }
            }
        });
        this.dfmRadioButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.serverTypeRadioButtonGroup = new ButtonGroup();
        this.serverTypeRadioButtonGroup.add(this.ontapRadioButton);
        this.serverTypeRadioButtonGroup.add(this.dfmRadioButton);
        this.radioPanel = new JPanel(new GridLayout(2, 1));
        this.radioPanel.add(this.ontapRadioButton);
        this.radioPanel.add(this.dfmRadioButton);
        this.radioPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Server Type "));
        jPanel.add(this.radioPanel);
    }

    private void addServerCredentialPanel(JPanel jPanel) {
        this.serverCredentialPanel = new JPanel(new BorderLayout());
        this.serverCredentialPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, 5));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1, 0, 5));
        JLabel jLabel = new JLabel("Server");
        this.serverTextField = new JTextField(16);
        this.addControlKeyListener(this.serverTextField);
        this.serverTextField.addKeyListener(new KeyOperationsListener(this.dialog));
        JLabel jLabel2 = new JLabel("Username");
        this.userTextField = new JTextField(16);
        this.addControlKeyListener(this.userTextField);
        this.userTextField.addKeyListener(new KeyOperationsListener(this.dialog));
        JLabel jLabel3 = new JLabel("Password");
        this.passwordField = new JPasswordField(16);
        this.addControlKeyListener(this.passwordField);
        this.passwordField.addKeyListener(new KeyOperationsListener(this.dialog));
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel2.add(jLabel3);
        jPanel3.add(this.serverTextField);
        jPanel3.add(this.userTextField);
        jPanel3.add(this.passwordField);
        this.serverCredentialPanel.add((Component)jPanel2, "West");
        this.serverCredentialPanel.add((Component)jPanel3, "East");
        jPanel.add(this.serverCredentialPanel);
    }

    private void addConnectOptionsButtons(JPanel jPanel) {
        this.connectOptionsButtonPanel = new JPanel();
        this.connectButton = new JButton("Connect");
        this.cancelButton = new JButton("Cancel");
        this.optionsButton = new JToggleButton("Advanced >>");
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.connect();
            }
        });
        this.connectButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.dispose();
            }
        });
        this.cancelButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.optionsButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ConnectDialog.this.optionsButton.setText("Basic <<");
                    ConnectDialog.this.advancedOptionsPanelWithEmptyBorder.setVisible(true);
                    if (ConnectDialog.this.ontapRadioButton.isSelected()) {
                        ConnectDialog.this.dialog.setSize(ConnectDialog.this.dialogAdvancedOntapDim);
                    } else {
                        ConnectDialog.this.dialog.setSize(ConnectDialog.this.dialogAdvancedDfmDim);
                    }
                } else {
                    ConnectDialog.this.optionsButton.setText("Advanced >>");
                    ConnectDialog.this.advancedOptionsPanelWithEmptyBorder.setVisible(false);
                    ConnectDialog.this.dialog.setSize(ConnectDialog.this.dialogBasicDim);
                }
            }
        });
        this.optionsButton.addKeyListener(new KeyOperationsListener(this.dialog));
        this.connectOptionsButtonPanel.add(this.connectButton);
        this.connectOptionsButtonPanel.add(this.cancelButton);
        this.connectOptionsButtonPanel.add(this.optionsButton);
        jPanel.add((Component)this.connectOptionsButtonPanel, "South");
    }

    private void addAdvancedOptionsPanel(JPanel jPanel) {
        this.advancedOptionsPanelWithEmptyBorder = new JPanel();
        this.advancedOptionsPanelWithEmptyBorder.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
        this.advancedOptionsPanel = new JPanel(new BorderLayout());
        this.advancedOptionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Advanced "));
        this.connectionParametersPanel = new JPanel(new GridLayout(1, 3));
        this.vfilerTunnelingPanel = new JPanel(new GridLayout(2, 3));
        this.vfilerTunnelingPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("Transport");
        String[] stringArray = new String[]{"HTTP", "HTTPS"};
        this.protocolComboBox = new JComboBox<String>(stringArray);
        this.protocolComboBox.setSelectedIndex(1);
        jPanel2.add(jLabel);
        jPanel2.add(this.protocolComboBox);
        this.protocolComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.portField.setText(Integer.toString(ConnectDialog.this.getSelectedDefaultPort()));
            }
        });
        this.protocolComboBox.addKeyListener(new KeyOperationsListener(this.dialog));
        JPanel jPanel3 = new JPanel();
        JLabel jLabel2 = new JLabel("Port");
        this.portField = new JTextField(4);
        this.portField.setText(Integer.toString(this.getSelectedDefaultPort()));
        jPanel3.add(jLabel2);
        jPanel3.add(this.portField);
        this.portField.addKeyListener(new KeyOperationsListener(this.dialog));
        JPanel jPanel4 = new JPanel();
        JCheckBox jCheckBox = new JCheckBox("Timeout");
        this.timeoutTextField = new JTextField(3);
        this.timeoutTextField.setEditable(false);
        this.timeoutTextField.addKeyListener(new KeyOperationsListener(this.dialog));
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                boolean bl = abstractButton.getModel().isSelected();
                if (bl) {
                    ConnectDialog.this.timeoutTextField.setEditable(true);
                } else {
                    ConnectDialog.this.timeoutTextField.setText("");
                    ConnectDialog.this.timeoutTextField.setEditable(false);
                }
            }
        });
        jCheckBox.addKeyListener(new KeyOperationsListener(this.dialog));
        JLabel jLabel3 = new JLabel("seconds");
        jPanel4.add(jCheckBox);
        jPanel4.add(this.timeoutTextField);
        jPanel4.add(jLabel3);
        this.connectionParametersPanel.add(jPanel2);
        this.connectionParametersPanel.add(jPanel3);
        this.connectionParametersPanel.add(jPanel4);
        this.advancedOptionsPanel.add((Component)this.connectionParametersPanel, "North");
        JLabel jLabel4 = new JLabel("");
        JCheckBox jCheckBox2 = new JCheckBox("Use vFiler or Vserver tunneling");
        jCheckBox2.setSelected(false);
        JLabel jLabel5 = new JLabel("vFiler unit or Vserver name");
        this.vfiler = new JTextField(16);
        this.vfiler.setEditable(false);
        this.vfiler.addKeyListener(new KeyOperationsListener(this.dialog));
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                boolean bl = abstractButton.getModel().isSelected();
                if (bl) {
                    ConnectDialog.this.vfiler.setEditable(true);
                } else {
                    ConnectDialog.this.vfiler.setText("");
                    ConnectDialog.this.vfiler.setEditable(false);
                }
            }
        });
        jCheckBox2.addKeyListener(new KeyOperationsListener(this.dialog));
        this.vfilerTunnelingPanel.add(jLabel4);
        this.vfilerTunnelingPanel.add(jLabel5);
        this.vfilerTunnelingPanel.add(jCheckBox2);
        this.vfilerTunnelingPanel.add(this.vfiler);
        this.advancedOptionsPanel.add((Component)this.vfilerTunnelingPanel, "South");
        this.advancedOptionsPanelWithEmptyBorder.add(this.advancedOptionsPanel);
        jPanel.add((Component)this.advancedOptionsPanelWithEmptyBorder, "Center");
    }

    private void addControlKeyListener(JComponent jComponent) {
        jComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ConnectDialog.this.connect();
                }
            }
        });
    }

    private int getSelectedDefaultPort() {
        if (this.ontapRadioButton.isSelected()) {
            if (this.protocolComboBox.getSelectedItem().toString().equals("HTTP")) {
                return 80;
            }
            return 443;
        }
        if (this.protocolComboBox.getSelectedItem().toString().equals("HTTP")) {
            return 8088;
        }
        return 8488;
    }

    private void connect() {
        String string;
        String string2 = "ontap";
        if (this.dfmRadioButton.isSelected()) {
            string2 = "dfm";
        }
        String string3 = this.serverTextField.getText().trim();
        String string4 = this.userTextField.getText().trim();
        String string5 = this.passwordField.getText().trim();
        String string6 = this.protocolComboBox.getSelectedItem().toString();
        int n = this.getSelectedDefaultPort();
        String string7 = this.portField.getText().trim();
        if (!string7.isEmpty()) {
            n = Integer.parseInt(string7);
        }
        int n2 = 0;
        String string8 = this.timeoutTextField.getText().trim();
        if (!string8.isEmpty()) {
            n2 = Integer.parseInt(string8);
        }
        if ((string = this.vfiler.getText().trim()).isEmpty()) {
            string = null;
        }
        Server server = null;
        try {
            server = new Server(string2, string3, string4, string5, string6, n, n2, string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(View.frame, "Failed to connect: " + exception.getMessage(), "Connection Error", 0);
            this.dispose();
            return;
        }
        int n3 = ExecuteDevelopPane.executeTabbedPane.getSelectedIndex();
        ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n3);
        executeTabPanel.setServer(server);
        View.statusBar.setServerStatus(server);
        String string9 = server.getApiDocVersion();
        if (!APIExplorerPanel.apiDropDownComboBox.selectApiDocVersion(string9)) {
            this.dispose();
            JOptionPane.showMessageDialog(View.frame, "API Version: " + string9 + " not listed.\nPlease select the API Document manually.", "Warning!", 2);
        }
        this.dispose();
    }
}

