/*
 * Decompiled with CFR 0.152.
 */
package zexplore.codegenerator;

import com.netapp.zapi.parser.Api;
import com.netapp.zapi.parser.Field;
import com.netapp.zapi.parser.Type;
import java.util.Collection;
import javax.swing.JEditorPane;
import zexplore.Server;
import zexplore.apiexplorer.APIExplorerPanel;
import zexplore.apiexplorer.APIParser;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteTabPanel;
import zexplore.menubar.preferences.PreferencesMenu;

public class XMLGenerator {
    private static StringBuffer code = new StringBuffer();
    public static final String spaceIndent = "  ";

    public static void generateXML(JEditorPane jEditorPane, String string, APIParser aPIParser) {
        Object object;
        String string2 = spaceIndent;
        code.setLength(0);
        code.append(jEditorPane.getText());
        if (code.length() == 0) {
            code.append(XMLGenerator.beginXML());
        } else {
            object = code.toString();
            object = ((String)object).replace(XMLGenerator.endXML(), "\n");
            code.setLength(0);
            code.append((String)object);
        }
        object = aPIParser.getApi(string);
        Collection<Field> collection = ((Api)object).getInputFields();
        if (PreferencesMenu.optionsItem.getCurrentIncludeCommentsInCode()) {
            code.append(string2 + "<!--" + ((Type)object).getDesc() + "-->\n");
        }
        if (collection.isEmpty()) {
            code.append(string2 + "<" + string + "/>\n");
        } else {
            code.append(string2 + "<" + string + ">\n");
            for (Field field : collection) {
                if (!field.getScope().isEmpty() && !field.getScope().contains(aPIParser.familyFilter)) continue;
                XMLGenerator.addRecuriveFields(field, string2 + spaceIndent);
            }
            code.append(string2 + "</" + string + ">\n");
        }
        code.append(XMLGenerator.endXML());
        jEditorPane.setText(code.toString());
    }

    private static void addRecuriveFields(Field field, String string) {
        Type type;
        if (!PreferencesMenu.optionsItem.getCurrentIncludeOptionalElements() && field.isOptional()) {
            return;
        }
        if (PreferencesMenu.optionsItem.getCurrentIncludeCommentsInCode()) {
            code.append(string + "<!--" + field.getDesc() + "-->\n");
        }
        if ((type = field.getTypedefType()).isPrimitive()) {
            code.append(string + "<" + field.getName() + ">" + "</" + field.getName() + ">\n");
            return;
        }
        Collection<Field> collection = type.getFields();
        code.append(string + "<" + field.getName() + ">\n");
        if (!field.getName().equals(type.getName())) {
            string = string + spaceIndent;
            if (PreferencesMenu.optionsItem.getCurrentIncludeCommentsInCode()) {
                code.append(string + "<!--" + type.getDesc() + "-->\n");
            }
            if (!collection.isEmpty()) {
                code.append(string + "<" + type.getName() + ">\n");
            } else {
                code.append(string + "<" + type.getName() + "></" + type.getName() + ">\n");
            }
        }
        for (Field field2 : collection) {
            XMLGenerator.addRecuriveFields(field2, string + spaceIndent);
        }
        if (!field.getName().equals(type.getName())) {
            if (!collection.isEmpty()) {
                code.append(string + "</" + type.getName() + ">\n");
            }
            string = string.replaceFirst(spaceIndent, "");
        }
        code.append(string + "</" + field.getName() + ">\n");
    }

    public static String beginXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        int n = ExecuteDevelopPane.executeTabbedPane.getSelectedIndex();
        ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n);
        Server server = executeTabPanel.getServer();
        String string = null;
        if (server != null) {
            string = server.getVTunnel();
        }
        if (string != null) {
            stringBuffer.append("<netapp  vfiler=\"" + string + "\" xmlns=\"http://www.netapp.com/filer/admin\" version=\"" + XMLGenerator.getApiVersion() + "\">\n");
        } else {
            stringBuffer.append("<netapp  xmlns=\"http://www.netapp.com/filer/admin\" version=\"" + XMLGenerator.getApiVersion() + "\">\n");
        }
        return stringBuffer.toString();
    }

    public static String endXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("</netapp>\n");
        return stringBuffer.toString();
    }

    private static String getApiVersion() {
        int n = ExecuteDevelopPane.executeTabbedPane.getSelectedIndex();
        ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n);
        Server server = executeTabPanel.getServer();
        if (server != null && server.getServerType().equals("ontap")) {
            return server.getApiVersion();
        }
        return APIExplorerPanel.apiDropDownComboBox.getApiVersion();
    }
}

