/*
 * Decompiled with CFR 0.152.
 */
package zexplore.codegenerator;

import java.io.IOException;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import zexplore.Server;
import zexplore.apiexplorer.APIExplorerPanel;
import zexplore.apiexplorer.APIParser;
import zexplore.codegenerator.CGenerator;
import zexplore.codegenerator.CSharpGenerator;
import zexplore.codegenerator.JavaGenerator;
import zexplore.codegenerator.LanguageCodeGenerator;
import zexplore.codegenerator.PerlGenerator;
import zexplore.codegenerator.PythonGenerator;
import zexplore.codegenerator.RubyGenerator;
import zexplore.codegenerator.XMLGenerator;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.develop.DevelopTabPanel;
import zexplore.executedevelop.execute.ExecuteTabPanel;
import zexplore.menubar.preferences.PreferencesMenu;

public class CodeGenerator {
    private static ExecuteTabPanel executeTabPanel = null;
    private static DevelopTabPanel developTabPanel = null;
    private static LanguageCodeGenerator languageGenerator = null;
    private static int numVar;
    private static int apiIndex;

    public static void generateCode(String string, APIParser aPIParser) {
        CodeGenerator.loadSelectedTabPanels();
        XMLGenerator.generateXML(CodeGenerator.executeTabPanel.inputPanel.input, string, aPIParser);
        CodeGenerator.generateSampleCode();
    }

    public static void generateSampleCode() {
        CodeGenerator.loadSelectedTabPanels();
        JEditorPane jEditorPane = CodeGenerator.developTabPanel.developPanel.developPane;
        String string = CodeGenerator.executeTabPanel.inputPanel.input.getText().trim();
        if (string == null || string.equals("")) {
            jEditorPane.setText("");
            return;
        }
        try {
            String string2;
            CodeGenerator.createLanguageGenerator();
            Document document = CodeGenerator.parseXML(string);
            String string3 = APIExplorerPanel.apiDropDownComboBox.getServerType();
            String string4 = CodeGenerator.getApiVersionFromXML(string);
            String[] stringArray = string4.split("\\.");
            String string5 = stringArray[0];
            String string6 = stringArray[1];
            boolean bl = APIExplorerPanel.apiDropDownComboBox.isClusterMode();
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = null;
            String string11 = null;
            Server server = executeTabPanel.getServer();
            if (server != null) {
                string7 = server.getServerFieldInfo("server");
                bl = server.isClusterMode();
                string8 = server.getServerFieldInfo("login");
                string3 = server.getServerType();
                string9 = server.getServerFieldInfo("protocol");
                string10 = server.getServerFieldInfo("port");
                string11 = server.getVTunnel();
            }
            languageGenerator.beginCode(string7, string5, string6, bl, string8, string3, string9, string10, string11);
            apiIndex = 0;
            for (Node node = document.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() == 1) {
                    numVar = 0;
                    string2 = languageGenerator.beginAPI(apiIndex, node.getNodeName());
                    NodeList nodeList = node.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        CodeGenerator.traverse(nodeList.item(i), string2);
                    }
                    languageGenerator.endAPI(apiIndex, string2);
                    ++apiIndex;
                    continue;
                }
                if (node.getNodeType() != 8) continue;
                languageGenerator.addComment(node.getNodeValue());
            }
            string2 = languageGenerator.endCode();
            jEditorPane.setText(string2);
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void traverse(Node node, String string) {
        if (node.getNodeType() == 1) {
            if (!node.hasChildNodes()) {
                languageGenerator.addSimpleParameter(string, node.getNodeName(), "");
            } else if (node.getChildNodes().getLength() == 1) {
                Node node2 = node.getChildNodes().item(0);
                if (node2.getNodeType() == 3) {
                    languageGenerator.addSimpleParameter(string, node.getNodeName(), node2.getNodeValue());
                }
            } else {
                String string2 = languageGenerator.addTypeParameter(string, node.getNodeName(), apiIndex, numVar++);
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    CodeGenerator.traverse(nodeList.item(i), string2);
                }
            }
        } else if (node.getNodeType() == 8) {
            languageGenerator.addComment(node.getNodeValue());
        }
    }

    private static Document parseXML(String string) throws SAXException, IOException, ParserConfigurationException {
        StringReader stringReader = new StringReader(string.trim());
        InputSource inputSource = new InputSource(stringReader);
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        documentBuilder.setErrorHandler(null);
        return documentBuilder.parse(inputSource);
    }

    private static void loadSelectedTabPanels() {
        int n = ExecuteDevelopPane.executeTabbedPane.getSelectedIndex();
        executeTabPanel = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n);
        developTabPanel = (DevelopTabPanel)ExecuteDevelopPane.developTabbedPane.getComponentAt(n);
    }

    private static void createLanguageGenerator() {
        String string = PreferencesMenu.languagesMenu.getSelectedLanguage();
        if (string.equalsIgnoreCase("Java")) {
            if (languageGenerator == null || !languageGenerator.getClass().getSimpleName().equals("JavaGenerator")) {
                languageGenerator = new JavaGenerator();
            }
        } else if (string.equalsIgnoreCase("Perl")) {
            if (languageGenerator == null || !languageGenerator.getClass().getSimpleName().equals("PerlGenerator")) {
                languageGenerator = new PerlGenerator();
            }
        } else if (string.equalsIgnoreCase("C#")) {
            if (languageGenerator == null || !languageGenerator.getClass().getSimpleName().equals("CSharpGenerator")) {
                languageGenerator = new CSharpGenerator();
            }
        } else if (string.equalsIgnoreCase("C")) {
            if (languageGenerator == null || !languageGenerator.getClass().getSimpleName().equals("CGenerator")) {
                languageGenerator = new CGenerator();
            }
        } else if (string.equalsIgnoreCase("Python")) {
            if (languageGenerator == null || !languageGenerator.getClass().getSimpleName().equals("PythonGenerator")) {
                languageGenerator = new PythonGenerator();
            }
        } else if (string.equalsIgnoreCase("Ruby") && (languageGenerator == null || !languageGenerator.getClass().getSimpleName().equals("RubyGenerator"))) {
            languageGenerator = new RubyGenerator();
        }
        CodeGenerator.developTabPanel.developPanel.setLanguageContentType(string);
    }

    private static String getApiVersionFromXML(String string) {
        int n = string.indexOf("<netapp");
        string = string.substring(n, string.length());
        int n2 = string.indexOf("version=");
        string = string.substring(n2, string.length());
        int n3 = string.indexOf(">");
        string = string.substring(0, n3);
        string = string.replaceAll("\"", "");
        string = string.replaceAll("version=", "");
        return string;
    }
}

