/*
 * Decompiled with CFR 0.152.
 */
package zexplore.apiexplorer;

import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.List;
import zexplore.apiexplorer.APIParser;
import zexplore.codegenerator.CodeGenerator;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteTabPanel;

class Drop
implements DropTargetListener {
    DropTarget dropTarget;
    List<String> apiNames;
    APIParser apiParser;

    public Drop(List<String> list, APIParser aPIParser) {
        this.apiNames = list;
        this.apiParser = aPIParser;
        int n = ExecuteDevelopPane.executeTabbedPane.getSelectedIndex();
        ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n);
        this.dropTarget = new DropTarget(executeTabPanel.inputPanel.input, 3, this, true, null);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.isValidDragDrop(dropTargetDragEvent.getDropAction(), dropTargetDragEvent.getCurrentDataFlavors())) {
            dropTargetDragEvent.acceptDrag(3);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.isValidDragDrop(dropTargetDropEvent.getDropAction(), dropTargetDropEvent.getCurrentDataFlavors())) {
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            try {
                for (String string : this.apiNames) {
                    CodeGenerator.generateCode(string, this.apiParser);
                }
                dropTargetDropEvent.dropComplete(true);
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace();
                dropTargetDropEvent.dropComplete(false);
            }
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private boolean isValidDragDrop(int n, DataFlavor[] dataFlavorArray) {
        if ((n & 3) != 0) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].getPrimaryType().equals("application") || !dataFlavorArray[i].getSubType().equals("x-java-serialized-object")) continue;
                return true;
            }
        }
        return false;
    }
}

