/*
 * Decompiled with CFR 0.152.
 */
package zexplore.apiexplorer;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import zexplore.apiexplorer.APIParser;
import zexplore.apiexplorer.TreeIcon;

public class APITreeIconRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -4057264163750755581L;
    private APIParser apiParser;

    public APITreeIconRenderer(APIParser aPIParser) {
        this.apiParser = aPIParser;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string;
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        int n2 = defaultMutableTreeNode.getLevel();
        String string2 = null;
        if (n2 == 1) {
            string = object.toString();
            string2 = this.apiParser.getCategorySynopsis(string);
            if (!string2.equals("")) {
                string2 = "<b>" + string2 + "</b> <br><br>";
            }
            string2 = string2 + this.apiParser.getCategoryDesc(string);
            this.setIcon(TreeIcon.categoryIcon);
        } else if (n2 == 2) {
            this.setIcon(TreeIcon.apiIcon);
            string2 = this.apiParser.getApiDesc(object.toString());
        } else if (n2 == 3) {
            if (defaultMutableTreeNode.getParent() != null) {
                String string3;
                string = defaultMutableTreeNode.getParent().toString();
                if (this.apiParser.isInputField(string, string3 = object.toString())) {
                    if (this.apiParser.isOptionalField(string, string3)) {
                        this.setIcon(TreeIcon.inputOptionalIcon);
                    } else {
                        this.setIcon(TreeIcon.inputMandatoryIcon);
                    }
                } else if (this.apiParser.isOutputField(string, string3)) {
                    if (this.apiParser.isOptionalField(string, string3)) {
                        this.setIcon(TreeIcon.outputOptionalIcon);
                    } else {
                        this.setIcon(TreeIcon.outputMandatoryIcon);
                    }
                }
                string2 = this.apiParser.getFieldDesc(string, string3);
            }
        } else if (n2 >= 4 && n2 % 2 == 0) {
            this.setIcon(TreeIcon.typeIcon);
            string2 = this.apiParser.getTypeDesc(object.toString());
        } else if (n2 >= 5 && n2 % 2 != 0) {
            if (this.apiParser.isOptionalTypedefField(object.toString())) {
                this.setIcon(TreeIcon.typedefOptionalIcon);
            } else {
                this.setIcon(TreeIcon.typedefMandatoryIcon);
            }
            string2 = this.apiParser.getTypedefDesc(object.toString());
        }
        string = "<html>\n<DIV style=\"position: left; width:150px\">\n" + string2 + "</html>";
        this.setToolTipText(string);
        return this;
    }
}

