/*
 * Decompiled with CFR 0.152.
 */
package zexplore.addedapisworkflows.workflows;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import util.TreeUtil;
import zexplore.KeyOperationsListener;
import zexplore.addedapisworkflows.workflows.WorkflowsList;
import zexplore.addedapisworkflows.workflows.WorkflowsTreeIconRenderer;

public class WorkflowsTree
extends JTree {
    private static final long serialVersionUID = 8235713477453317874L;
    private DefaultMutableTreeNode emptyRoot = new DefaultMutableTreeNode("");
    private DefaultTreeModel treeModel = new DefaultTreeModel(this.emptyRoot);
    private int predefinedWorkflowsCount = 0;
    private Map<Integer, Integer> WorkflowIndexToExecuteTabPanelIndex = new HashMap<Integer, Integer>();
    private Map<DefaultMutableTreeNode, String> nodeCommentMap = new HashMap<DefaultMutableTreeNode, String>();
    private List<String> predefinedWorkflowsNames = new ArrayList<String>();

    public WorkflowsTree() {
        this.predefinedWorkflowsCount = this.addPredefinedWorkflows();
        this.setModel(this.treeModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new WorkflowsTreeIconRenderer(this.predefinedWorkflowsNames));
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addKeyListener(new KeyOperationsListener());
    }

    private int addPredefinedWorkflows() {
        int n = 0;
        WorkflowsList workflowsList = new WorkflowsList();
        for (String string : workflowsList.getWorkflowsList()) {
            InputStream inputStream = null;
            String string2 = workflowsList.getFilePath(string);
            try {
                inputStream = this.getClass().getResourceAsStream("/" + string2);
                if (inputStream == null) {
                    inputStream = new FileInputStream(string2);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.toString());
            }
            DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.getTreeRootFromXMLStream(inputStream, this.nodeCommentMap);
            defaultMutableTreeNode.setUserObject(string);
            this.predefinedWorkflowsNames.add(string);
            this.treeModel.insertNodeInto(defaultMutableTreeNode, this.emptyRoot, this.emptyRoot.getChildCount());
            ++n;
        }
        return n;
    }

    public int addUserDefinedWorkflow(String string, String string2, int n) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.getTreeRootFromXMLStream(byteArrayInputStream, this.nodeCommentMap);
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode();
        }
        defaultMutableTreeNode.setUserObject(string2);
        if (n < 0) {
            n = this.emptyRoot.getChildCount();
        }
        this.treeModel.insertNodeInto(defaultMutableTreeNode, this.emptyRoot, n);
        return n;
    }

    public String removeUserDefinedWorkflow(int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeModel.getChild(this.emptyRoot, n);
        String string = (String)defaultMutableTreeNode.getUserObject();
        this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
        return string;
    }

    public int updateUserDefinedWorkflow(String string, int n) {
        String string2 = this.removeUserDefinedWorkflow(n);
        return this.addUserDefinedWorkflow(string, string2, n);
    }

    public int getExecuteTabPanelIndex(int n) {
        return this.WorkflowIndexToExecuteTabPanelIndex.get(n);
    }

    public void setExecuteTabPanelIndex(int n, int n2) {
        this.WorkflowIndexToExecuteTabPanelIndex.put(n, n2);
    }

    public int getPredefinedWorkflowsCount() {
        return this.predefinedWorkflowsCount;
    }

    public String getComment(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.nodeCommentMap == null) {
            return null;
        }
        return this.nodeCommentMap.get(defaultMutableTreeNode);
    }
}

