/*
 * Decompiled with CFR 0.152.
 */
package zexplore.addedapisworkflows.workflows;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import zexplore.IconMap;
import zexplore.KeyOperationsListener;
import zexplore.addedapisworkflows.workflows.WorkflowsTreePanel;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteTabPanel;

public class WorkflowsMoveDownButton
extends JButton {
    private static final long serialVersionUID = -494332131090545773L;

    public WorkflowsMoveDownButton() {
        super(new IconMap().getIcon("down-arrow"));
        String string = "Press to Move the node down";
        this.setToolTipText(string);
        this.setContentAreaFilled(false);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                WorkflowsMoveDownButton.this.setContentAreaFilled(true);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                WorkflowsMoveDownButton.this.setContentAreaFilled(false);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                WorkflowsMoveDownButton.this.moveDown();
            }
        });
        this.addKeyListener(new KeyOperationsListener());
    }

    private void moveDown() {
        int n;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)WorkflowsTreePanel.tree.getModel();
        TreePath[] treePathArray = WorkflowsTreePanel.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length <= 0) {
            return;
        }
        int[] nArray = new int[treePathArray.length];
        for (n = 0; n < treePathArray.length; ++n) {
            nArray[n] = WorkflowsTreePanel.tree.getRowForPath(treePathArray[n]);
        }
        Arrays.sort(nArray);
        for (n = nArray.length - 1; n >= 0; --n) {
            TreePath treePath = WorkflowsTreePanel.tree.getPathForRow(nArray[n]);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            int n2 = defaultTreeModel.getIndexOfChild(defaultMutableTreeNode2, defaultMutableTreeNode);
            if (n2 == defaultMutableTreeNode2.getChildCount() - 1) continue;
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n2 + 1);
            TreePath treePath2 = new TreePath(defaultMutableTreeNode3.getPath());
            int n3 = WorkflowsTreePanel.tree.getRowForPath(treePath2);
            if (n != nArray.length - 1 && nArray[n + 1] == n3) continue;
            if (defaultMutableTreeNode.getLevel() == 1) {
                if (n2 <= WorkflowsTreePanel.tree.getPredefinedWorkflowsCount() - 1) continue;
                int n4 = WorkflowsTreePanel.tree.getExecuteTabPanelIndex(n2);
                int n5 = WorkflowsTreePanel.tree.getExecuteTabPanelIndex(n2 + 1);
                ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n4);
                ExecuteTabPanel executeTabPanel2 = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n5);
                executeTabPanel.setWorkflowNodeIndex(n2 + 1);
                executeTabPanel2.setWorkflowNodeIndex(n2);
                WorkflowsTreePanel.tree.setExecuteTabPanelIndex(n2 + 1, n4);
                WorkflowsTreePanel.tree.setExecuteTabPanelIndex(n2, n5);
            }
            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, n2 + 1);
            nArray[n] = nArray[n] + 1;
        }
        WorkflowsTreePanel.tree.setSelectionRows(nArray);
    }
}

