/*
 * Decompiled with CFR 0.152.
 */
package zexplore;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import zexplore.preferences.PreferenceConstant;
import zexplore.preferences.ZapiPreferences;

public class OptionsDialog
extends JDialog {
    private static final long serialVersionUID = 2640569712496648176L;
    private JCheckBox commentsCheck;
    private JCheckBox optionalsCheck;
    private JCheckBox highlightCheck;
    private JCheckBox iteratorCheck;
    private JTextField fetchSizeField;
    private JCheckBox jobSizeCheck;
    private JTextField jobSizeField;
    private JCheckBox ruleCheck;
    private JCheckBox checkForUpdatesCheck;
    private JCheckBox formatOutputCheck;
    private final JDialog optionsDialog = this;

    public OptionsDialog(JFrame jFrame) {
        super(jFrame, "Preferences", true);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.addOptions(jPanel);
        this.loadOptions();
        this.getContentPane().add(jPanel);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.setVisible(true);
    }

    private void addOptions(JPanel jPanel) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setTabPlacement(2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        this.addOptionsComponents(jPanel2);
        jTabbedPane.addTab("General", jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        this.addHistoryComponents(jPanel3);
        jTabbedPane.addTab("Job History", jPanel3);
        jPanel.add((Component)jTabbedPane, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        this.addOptionsButtons(jPanel4);
        jPanel.add((Component)jPanel4, "South");
    }

    private void addOptionsButtons(Container container) {
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.acceptChanges();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.cancelChanges();
            }
        });
        JButton jButton3 = new JButton("Restore Defaults");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog.this.restoreDefaults();
            }
        });
        container.add(jButton3);
        container.add(Box.createRigidArea(new Dimension(30, 0)));
        container.add(jButton);
        container.add(jButton2);
    }

    private void addOptionsComponents(Container container) {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        JPanel jPanel8 = new JPanel(new FlowLayout(0));
        this.commentsCheck = new JCheckBox("Include comments in generated code");
        this.optionalsCheck = new JCheckBox("Include optional elements in code generation");
        this.highlightCheck = new JCheckBox("Highlight sample text in code generation");
        this.ruleCheck = new JCheckBox("Enable rule engine in Explore");
        this.checkForUpdatesCheck = new JCheckBox("Check for updates on startup");
        this.formatOutputCheck = new JCheckBox("Format XML Output");
        this.iteratorCheck = new JCheckBox("Enable iterator comprehension");
        this.fetchSizeField = new JTextField(10);
        JLabel jLabel = new JLabel("Iterator fetch size");
        jPanel.add(this.commentsCheck);
        container.add(jPanel);
        jPanel2.add(this.optionalsCheck);
        container.add(jPanel2);
        jPanel3.add(this.highlightCheck);
        container.add(jPanel3);
        jPanel4.add(this.ruleCheck);
        container.add(jPanel4);
        jPanel7.add(this.checkForUpdatesCheck);
        container.add(jPanel7);
        jPanel8.add(this.formatOutputCheck);
        container.add(jPanel8);
        jPanel5.add(this.iteratorCheck);
        container.add(jPanel5);
        jPanel6.add(jLabel);
        jPanel6.add(this.fetchSizeField);
        container.add(jPanel6);
        container.add(Box.createRigidArea(new Dimension(0, 30)));
    }

    private void addHistoryComponents(Container container) {
        JPanel jPanel = new JPanel();
        this.jobSizeCheck = new JCheckBox("Limit my job history to ");
        this.jobSizeField = new JTextField(3);
        jPanel.add(this.jobSizeCheck);
        jPanel.add(this.jobSizeField);
        container.add(jPanel);
    }

    private void cancelChanges() {
        this.optionsDialog.setVisible(false);
    }

    private void acceptChanges() {
        if (this.storePreferences() == 0) {
            this.optionsDialog.setVisible(false);
        }
    }

    private void loadOptions() {
        boolean bl = ZapiPreferences.getBoolean(PreferenceConstant.ENABLE_COMMENTS);
        boolean bl2 = ZapiPreferences.getBoolean(PreferenceConstant.ENABLE_OPTIONALS);
        boolean bl3 = ZapiPreferences.getBoolean(PreferenceConstant.ENABLE_HIGHLIGHT);
        boolean bl4 = ZapiPreferences.getBoolean(PreferenceConstant.ENABLE_RULE_ENGINE);
        boolean bl5 = ZapiPreferences.getBoolean(PreferenceConstant.ENABLE_ITERATORS);
        int n = ZapiPreferences.getInt(PreferenceConstant.ITERATOR_FETCH_SIZE);
        boolean bl6 = ZapiPreferences.getBoolean(PreferenceConstant.HISTORY_LIMITED);
        int n2 = ZapiPreferences.getInt(PreferenceConstant.HISTORY_SIZE);
        boolean bl7 = ZapiPreferences.getBoolean(PreferenceConstant.ENABLE_CHECK_UPDATES);
        boolean bl8 = ZapiPreferences.getBoolean(PreferenceConstant.FORMAT_OUTPUT);
        this.commentsCheck.setSelected(bl);
        this.optionalsCheck.setSelected(bl2);
        this.highlightCheck.setSelected(bl3);
        this.ruleCheck.setSelected(bl4);
        this.checkForUpdatesCheck.setSelected(bl7);
        this.formatOutputCheck.setSelected(bl8);
        this.iteratorCheck.setSelected(bl5);
        this.fetchSizeField.setText(Integer.toString(n));
        this.jobSizeCheck.setSelected(bl6);
        this.jobSizeField.setText(Integer.toString(n2));
    }

    private int storePreferences() {
        int n;
        int n2;
        try {
            n2 = Integer.parseInt(this.fetchSizeField.getText());
            if (n2 < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Iterator fetch size must be an integer", "Error", 0);
            return -1;
        }
        try {
            n = Integer.parseInt(this.jobSizeField.getText());
            if (n < 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Job history size must be a positive integer.", "Error", 0);
            return -1;
        }
        ZapiPreferences.putBoolean(PreferenceConstant.ENABLE_COMMENTS, this.commentsCheck.isSelected());
        ZapiPreferences.putBoolean(PreferenceConstant.ENABLE_OPTIONALS, this.optionalsCheck.isSelected());
        ZapiPreferences.putBoolean(PreferenceConstant.ENABLE_HIGHLIGHT, this.highlightCheck.isSelected());
        ZapiPreferences.putBoolean(PreferenceConstant.ENABLE_RULE_ENGINE, this.ruleCheck.isSelected());
        ZapiPreferences.putBoolean(PreferenceConstant.ENABLE_CHECK_UPDATES, this.checkForUpdatesCheck.isSelected());
        ZapiPreferences.putBoolean(PreferenceConstant.FORMAT_OUTPUT, this.formatOutputCheck.isSelected());
        ZapiPreferences.putBoolean(PreferenceConstant.ENABLE_ITERATORS, this.iteratorCheck.isSelected());
        ZapiPreferences.putInt(PreferenceConstant.ITERATOR_FETCH_SIZE, n2);
        ZapiPreferences.putBoolean(PreferenceConstant.HISTORY_LIMITED, this.jobSizeCheck.isSelected());
        ZapiPreferences.putInt(PreferenceConstant.HISTORY_SIZE, n);
        return 0;
    }

    private void restoreDefaults() {
        ZapiPreferences.putBoolean(PreferenceConstant.ENABLE_COMMENTS, (Boolean)PreferenceConstant.ENABLE_COMMENTS.getDefaultValue());
        ZapiPreferences.putBoolean(PreferenceConstant.ENABLE_OPTIONALS, (Boolean)PreferenceConstant.ENABLE_OPTIONALS.getDefaultValue());
        ZapiPreferences.putBoolean(PreferenceConstant.ENABLE_HIGHLIGHT, (Boolean)PreferenceConstant.ENABLE_HIGHLIGHT.getDefaultValue());
        ZapiPreferences.putBoolean(PreferenceConstant.ENABLE_RULE_ENGINE, (Boolean)PreferenceConstant.ENABLE_RULE_ENGINE.getDefaultValue());
        ZapiPreferences.putBoolean(PreferenceConstant.ENABLE_ITERATORS, (Boolean)PreferenceConstant.ENABLE_ITERATORS.getDefaultValue());
        ZapiPreferences.putInt(PreferenceConstant.ITERATOR_FETCH_SIZE, (Integer)PreferenceConstant.ITERATOR_FETCH_SIZE.getDefaultValue());
        ZapiPreferences.putBoolean(PreferenceConstant.HISTORY_LIMITED, (Boolean)PreferenceConstant.HISTORY_LIMITED.getDefaultValue());
        ZapiPreferences.putInt(PreferenceConstant.HISTORY_SIZE, (Integer)PreferenceConstant.HISTORY_SIZE.getDefaultValue());
        this.loadOptions();
    }
}

