/*
 * Decompiled with CFR 0.152.
 */
package zexplore;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import model.generator.ZephyrCodeGen;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import zexplore.ConnectionInfo;
import zexplore.ConnectionType;
import zexplore.ExecuteJob;
import zexplore.Job;
import zexplore.JobSpawner;
import zexplore.View;
import zexplore.preferences.PreferenceConstant;
import zexplore.preferences.ZapiPreferences;

public class ConnectionPanel
extends JPanel
implements JobSpawner {
    private static final long serialVersionUID = -7766828006518059630L;
    private JTextComponent host;
    private JTextComponent portField;
    private JTextComponent user;
    private JTextComponent password;
    private JTextComponent vfiler;
    private final View view;
    private JPanel panel;
    private String hostType;
    private JComboBox protocolComboBox;
    private int port;
    private ConnectionType connectionType;
    private ProgressMonitor progressMonitor;
    private ArrayList<String> filerQueries = new ArrayList();
    private ArrayList<String> dfmQueries = new ArrayList();
    private Vector<ConnectionInfo> connectionList;
    private HashMap<String, Job> infoHistory;
    private ArrayList<Job> waitingOnList;

    public ConnectionPanel(View view, String string) {
        Object object;
        this.view = view;
        this.panel = this;
        this.hostType = string;
        try {
            object = ZapiPreferences.getObject(PreferenceConstant.CONNECTION_LIST);
        }
        catch (Exception exception) {
            object = null;
        }
        this.loadQueries();
        this.addInputPanel();
        this.infoHistory = new HashMap();
        this.waitingOnList = new ArrayList();
        this.connectionList = object == null || !(object instanceof Vector) ? new Vector() : (Vector)object;
    }

    private void loadQueries() {
        this.filerQueries.add("<system-get-ontapi-version/>");
        this.filerQueries.add("<system-get-version/>");
        this.filerQueries.add("<system-get-info/>");
        this.filerQueries.add("<net-interface-get/>");
        this.dfmQueries.add("<dfm-about/>");
    }

    private void addInputPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(6, 2, 80, 0));
        JLabel jLabel = new JLabel("");
        if (this.hostType.equals("filer")) {
            jLabel.setText("Connect to storage system or simulator");
        } else if (this.hostType.equals("dfm")) {
            jLabel.setText("Connect to DataFabric Manager server");
        }
        this.host = new JTextField(16);
        this.addControlKeyListener(this.host);
        JLabel jLabel2 = new JLabel("Username");
        this.user = new JTextField(16);
        this.addControlKeyListener(this.user);
        JLabel jLabel3 = new JLabel("Password");
        this.password = new JPasswordField(16);
        this.addControlKeyListener(this.password);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 25));
        JLabel jLabel4 = new JLabel("Transport");
        JLabel jLabel5 = new JLabel("Port");
        jPanel3.add((Component)jLabel4, "West");
        jPanel3.add((Component)jLabel5, "East");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        String[] stringArray = new String[]{"HTTP", "HTTPS"};
        this.protocolComboBox = new JComboBox<String>(stringArray);
        this.portField = new JTextField(5);
        this.portField.setText(Integer.toString(this.getSelectedDefaultPort()));
        this.protocolComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionPanel.this.portField.setText(Integer.toString(ConnectionPanel.this.getSelectedDefaultPort()));
            }
        });
        jPanel4.add((Component)this.protocolComboBox, "West");
        jPanel4.add((Component)this.portField, "East");
        JLabel jLabel6 = new JLabel("");
        JCheckBox jCheckBox = new JCheckBox("Use vFiler or Vserver tunneling");
        jCheckBox.setSelected(false);
        JLabel jLabel7 = new JLabel("vFiler unit or Vserver name");
        this.vfiler = new JTextField(16);
        this.vfiler.setEditable(false);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                boolean bl = abstractButton.getModel().isSelected();
                if (bl) {
                    ConnectionPanel.this.vfiler.setEditable(true);
                } else {
                    ConnectionPanel.this.vfiler.setText("");
                    ConnectionPanel.this.vfiler.setEditable(false);
                }
            }
        });
        boolean bl = true;
        if (this.hostType.contains("filer")) {
            bl = true;
        } else if (this.hostType.contains("dfm")) {
            bl = false;
        }
        jLabel7.setVisible(bl);
        jCheckBox.setVisible(bl);
        this.vfiler.setVisible(bl);
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        jPanel2.add(this.host);
        jPanel2.add(this.user);
        jPanel2.add(jPanel3);
        jPanel2.add(jLabel3);
        jPanel2.add(jPanel4);
        jPanel2.add(this.password);
        jPanel2.add(jLabel6);
        jPanel2.add(jLabel7);
        jPanel2.add(jCheckBox);
        jPanel2.add(this.vfiler);
        jPanel.add((Component)jPanel2, "East");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createEmptyBorder(10, 200, 0, 200));
        JButton jButton = new JButton("Connect");
        if (this.hostType.equals("filer")) {
            jButton.setToolTipText("Connect to the storage system or simulator to load corresponding Data ONTAP APIs.");
        } else if (this.hostType.equals("dfm")) {
            jButton.setToolTipText("Connect to the DataFabric Manager server to load corresponding DFM APIs.");
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionPanel.this.connect();
            }
        });
        jPanel5.add(jButton);
        jPanel.add((Component)jPanel5, "South");
        this.panel.add(jPanel);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public String getHostName() {
        return this.host.getText().trim();
    }

    public String getUserName() {
        return this.user.getText().trim();
    }

    public String getVfilerName() {
        return this.vfiler.getText().trim();
    }

    public String getProtocol() {
        return this.protocolComboBox.getSelectedItem().toString();
    }

    public String getPort() {
        return this.portField.getText().trim();
    }

    private ConnectionInfo getConnectionInfo() {
        String string = this.host.getText();
        String string2 = this.getProtocol();
        String string3 = this.user.getText();
        String string4 = this.password.getText();
        this.port = Integer.parseInt(this.portField.getText());
        this.connectionType = this.getConnectionType();
        return new ConnectionInfo(string, string2, this.port, string3, string4, this.connectionType, "");
    }

    private ConnectionType getConnectionType() {
        String string = this.protocolComboBox.getSelectedItem().toString();
        ConnectionType connectionType = null;
        if (string.equals("HTTP") && this.hostType.equals("filer")) {
            connectionType = ConnectionType.FILER;
        } else if (string.equals("HTTPS") && this.hostType.equals("filer")) {
            connectionType = ConnectionType.FILER_SECURE;
        } else if (string.equals("HTTP") && this.hostType.equals("dfm")) {
            connectionType = ConnectionType.DFM;
        } else if (string.equals("HTTPS") && this.hostType.equals("dfm")) {
            connectionType = ConnectionType.DFM_SECURE;
        }
        return connectionType;
    }

    private void addControlKeyListener(JComponent jComponent) {
        jComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ConnectionPanel.this.connect();
                }
            }
        });
    }

    private int getSelectedDefaultPort() {
        ConnectionType connectionType = this.getConnectionType();
        return connectionType.getDefaultPort();
    }

    private void connect() {
        if (!this.validTextInput(this.host.getText())) {
            this.popupError("You must specify a host.");
            return;
        }
        if (!this.validPortInput(this.portField.getText())) {
            this.popupError("Invalid port specified.");
            return;
        }
        if (!this.validTextInput(this.user.getText())) {
            this.popupError("You must provide a username.");
            return;
        }
        String string = "";
        UIManager.put("ProgressMonitor.progressText", string);
        this.progressMonitor = new ProgressMonitor(this.panel, "Connecting...", null, 0, Integer.MAX_VALUE);
        this.progressMonitor.setMillisToDecideToPopup(0);
        this.progressMonitor.setMillisToPopup(0);
        this.progressMonitor.setProgress(1);
        String string2 = this.host.getText().trim();
        String string3 = this.getProtocol();
        int n = Integer.parseInt(this.portField.getText());
        String string4 = this.user.getText();
        String string5 = this.password.getText();
        ConnectionType connectionType = this.connectionType;
        ConnectionInfo connectionInfo = new ConnectionInfo(string2, string3, n, string4, string5, connectionType, null);
        this.infoHistory.clear();
        this.waitingOnList.clear();
        ArrayList<String> arrayList = null;
        arrayList = connectionType == ConnectionType.FILER || connectionType == ConnectionType.FILER_SECURE ? this.filerQueries : this.dfmQueries;
        for (String string6 : arrayList) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<netapp xmlns=\"http://www.netapp.com/filer/admin\" version=\"1.0\">");
            stringBuilder.append(string6);
            stringBuilder.append("</netapp>");
            String string7 = stringBuilder.toString();
            Job job = new Job(connectionInfo, string7, null, null, null, string6);
            this.waitingOnList.add(job);
            ExecuteJob executeJob = new ExecuteJob(job, this);
            executeJob.execute();
        }
    }

    private boolean validPortInput(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return n >= 0 && n <= 65535;
    }

    private boolean validTextInput(String string) {
        return string != null && !string.trim().equals("");
    }

    private void popupError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    @Override
    public void jobComplete(Job job) {
        if (!this.waitingOnList.contains(job) || this.progressMonitor.isCanceled()) {
            return;
        }
        this.infoHistory.put(job.getApi(), job);
        this.progressMonitor.close();
        if (!job.getSuccess()) {
            this.infoHistory.clear();
            this.waitingOnList.clear();
            this.popupError("Error connecting:\n" + job.getOutput());
            return;
        }
        ConnectionInfo connectionInfo = job.getConnectionInfo();
        ConnectionType connectionType = connectionInfo.getConnectionType();
        if (connectionType == ConnectionType.FILER || connectionType == ConnectionType.FILER_SECURE) {
            if (this.infoHistory.size() == this.filerQueries.size()) {
                this.connectFiler();
            }
        } else if (this.infoHistory.size() == this.dfmQueries.size()) {
            this.connectDFM();
        }
    }

    private void connectFiler() {
        if (this.isClusterMode()) {
            this.connectFilerClusterMode();
        } else {
            this.connectFilerNonCluster();
        }
    }

    private void connectFilerClusterMode() {
        String string;
        Object object;
        String string2;
        String string3;
        Object object2;
        Object object3;
        String string4;
        try {
            string4 = this.infoHistory.get("<system-get-ontapi-version/>").getOutput();
            object3 = this.infoHistory.get("<system-get-version/>").getOutput();
            object2 = this.parseDoc(string4);
            string3 = object2.selectSingleNode("//major-version").getText();
            string2 = object2.selectSingleNode("//minor-version").getText();
            object = this.parseDoc((String)object3);
            string = object.selectSingleNode("//version").getText();
        }
        catch (Exception exception) {
            this.popupError("Error connecting:\n" + exception.getMessage());
            return;
        }
        string4 = string3 + "." + string2 + "_Cluster_Mode";
        if (!this.infoHistory.get("<net-interface-get/>").getOutput().contains("Unable to find API")) {
            string4 = string3 + "." + string2 + "_Vserver";
        }
        object3 = this.infoHistory.get("<system-get-ontapi-version/>");
        object2 = ((Job)object3).getConnectionInfo();
        object = String.format("Connected to %s@%s:%s (%s). [%s / %s]", ((ConnectionInfo)object2).getUsername(), ((ConnectionInfo)object2).getHost(), ((ConnectionInfo)object2).getPort(), ((ConnectionInfo)object2).getProtocol(), string, string4);
    }

    private void connectFilerNonCluster() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        Object object;
        Object object2;
        Object object3;
        String string6;
        try {
            string6 = this.infoHistory.get("<system-get-ontapi-version/>").getOutput();
            object3 = this.infoHistory.get("<system-get-version/>").getOutput();
            object2 = this.infoHistory.get("<system-get-info/>").getOutput();
            object = this.parseDoc(string6);
            string5 = object.selectSingleNode("//major-version").getText();
            string4 = object.selectSingleNode("//minor-version").getText();
            Document document = this.parseDoc((String)object3);
            string3 = document.selectSingleNode("//version").getText();
            Document document2 = this.parseDoc((String)object2);
            string2 = document2.selectSingleNode("//system-name").getText();
            string = document2.selectSingleNode("//system-model").getText();
        }
        catch (Exception exception) {
            this.popupError("Error connecting:\n" + exception.getMessage());
            return;
        }
        string6 = string5 + "." + string4;
        if (Integer.parseInt(string5) >= 1 && Integer.parseInt(string4) >= 15) {
            string6 = string6 + "_7_Mode";
        }
        object3 = this.infoHistory.get("<system-get-ontapi-version/>");
        object2 = ((Job)object3).getConnectionInfo();
        ((ConnectionInfo)object2).setHostName(string2);
        object = String.format("Connected to %s (%s@%s:%s (%s)) . %s. [%s / %s]", string2, ((ConnectionInfo)object2).getUsername(), ((ConnectionInfo)object2).getHost(), ((ConnectionInfo)object2).getPort(), ((ConnectionInfo)object2).getProtocol(), string, string3, string6);
    }

    private Document parseDoc(String string) throws Exception, DocumentException {
        if (string.equals("Unauthorized")) {
            throw new Exception("Invalid username or password");
        }
        Document document = ZephyrCodeGen.parseNonvalidating(string);
        Element element = (Element)document.selectSingleNode("//results");
        if (element.attributeValue("status").equals("failed")) {
            throw new Exception(element.attributeValue("reason"));
        }
        return document;
    }

    private void connectDFM() {
        String string;
        String string2;
        Object object;
        Job job = this.infoHistory.get("<dfm-about/>");
        ConnectionInfo connectionInfo = job.getConnectionInfo();
        String string3 = job.getOutput();
        try {
            object = this.parseDoc(string3);
            string2 = object.selectSingleNode("//version").getText();
            string = object.selectSingleNode("//host-name").getText();
        }
        catch (Exception exception) {
            this.popupError("Error connecting:\n" + exception.getMessage());
            return;
        }
        connectionInfo.setHostName(string);
        object = Pattern.compile("^(\\d+\\.\\d+)");
        Matcher matcher = ((Pattern)object).matcher(string2);
        if (matcher.find()) {
            String string4 = matcher.group();
            String string5 = String.format("Connected to %s (%s@%s:%s (%s)). [%s]", string, connectionInfo.getUsername(), connectionInfo.getHost(), connectionInfo.getPort(), connectionInfo.getProtocol(), string2);
        } else {
            this.popupError("Couldn't parse version number:\n" + string2);
        }
    }

    private boolean isClusterMode() {
        try {
            String string = this.infoHistory.get("<system-get-ontapi-version/>").getOutput();
            Document document = this.parseDoc(string);
            String string2 = document.selectSingleNode("//major-version").getText();
            String string3 = document.selectSingleNode("//minor-version").getText();
            if (Integer.parseInt(string2) >= 1 && Integer.parseInt(string3) >= 15) {
                String string4 = this.infoHistory.get("<system-get-version/>").getOutput();
                int n = string4.indexOf("<is-clustered>true</is-clustered>");
                return n != -1;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

