/*
 * Decompiled with CFR 0.152.
 */
package model.validator.rules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import model.ZephyrDesc;
import model.ZephyrDescList;
import model.ZephyrKeyword;
import model.validator.ErrorMessage;
import model.validator.MessageType;
import model.validator.ValidatorMessage;
import model.validator.rules.AbstractRule;
import model.validator.rules.Rule;

public class TypedefRule
extends AbstractRule
implements Rule {
    private Map<String, ZephyrDesc> types = new HashMap<String, ZephyrDesc>();
    private static final String[] primitives = new String[]{"boolean", "integer", "obj-name-or-id", "string"};

    @Override
    public void check(List<ValidatorMessage> list, ZephyrDesc zephyrDesc, int n) {
        Object object;
        block14: {
            ZephyrDescList zephyrDescList;
            block15: {
                block17: {
                    block16: {
                        if (n != 1 || zephyrDesc.getKeyword() != ZephyrKeyword.TYPEDEF) break block14;
                        if (this.types.containsKey(zephyrDesc.getValue())) {
                            list.add(new ErrorMessage(zephyrDesc, MessageType.DUPLICATE_TYPEDEF, zephyrDesc.getValue()));
                        } else {
                            this.types.put(zephyrDesc.getValue(), zephyrDesc);
                        }
                        object = zephyrDesc.getChildren(ZephyrKeyword.ELEMENT);
                        zephyrDescList = zephyrDesc.getChildren(ZephyrKeyword.TYPE);
                        if (object.size() != 0) break block15;
                        if (zephyrDescList.size() != 0) break block16;
                        list.add(new ErrorMessage(zephyrDesc, MessageType.EMPTY_TYPE, zephyrDesc.getValue()));
                        break block14;
                    }
                    if (zephyrDescList.size() <= 1) break block17;
                    list.add(new ErrorMessage(zephyrDesc, MessageType.MULTIPLE_TYPES, zephyrDesc.getValue()));
                    break block14;
                }
                if (this.isPrimitive(((ZephyrDesc)zephyrDescList.get(0)).getValue())) break block14;
                list.add(new ErrorMessage(zephyrDesc, MessageType.TYPEDEF_SIMPLE_ALIAS, zephyrDesc.getValue()));
                break block14;
            }
            if (zephyrDescList.size() > 0) {
                list.add(new ErrorMessage(zephyrDesc, MessageType.INVALID_TYPEDEF, zephyrDesc.getValue()));
            }
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ZephyrDescList zephyrDescList2;
                ZephyrDesc zephyrDesc2 = (ZephyrDesc)iterator.next();
                if (hashSet.contains(zephyrDesc2.getValue())) {
                    list.add(new ErrorMessage(zephyrDesc2, MessageType.DUPLICATE_FIELDS, zephyrDesc.getValue(), zephyrDesc2.getValue()));
                } else {
                    hashSet.add(zephyrDesc2.getValue());
                }
                if (zephyrDesc2.getValue().matches(".*[^a-z\\d-]+.*")) {
                    list.add(new ErrorMessage(zephyrDesc2, MessageType.INVALID_ELEMENT_NAME, zephyrDesc2.getValue()));
                }
                if ((zephyrDescList2 = zephyrDesc2.getChildren(ZephyrKeyword.TYPE)).size() > 1) {
                    list.add(new ErrorMessage(zephyrDesc2, MessageType.MULTIPLE_TYPES, zephyrDesc2.getValue()));
                    continue;
                }
                if (zephyrDescList2.size() == 0) {
                    list.add(new ErrorMessage(zephyrDesc2, MessageType.EMPTY_ELEMENT, zephyrDesc2.getValue()));
                    continue;
                }
                for (ZephyrDesc zephyrDesc3 : zephyrDescList2) {
                    if (!zephyrDesc3.getValue().equals("boolean") || !zephyrDesc2.getValue().matches("^(is-|has-).*")) {
                        // empty if block
                    }
                    if (!zephyrDesc3.getValue().equals("integer")) continue;
                    this.checkParam(zephyrDesc3, list);
                }
            }
        }
        if (n == 2 && zephyrDesc.getKeyword() == ZephyrKeyword.TYPE) {
            object = zephyrDesc.getValue().trim();
            if (((String)object).endsWith("[]")) {
                object = ((String)object).substring(0, ((String)object).length() - 2);
            }
            if (!this.isPrimitive((String)object) && !this.types.containsKey(object)) {
                list.add(new ErrorMessage(zephyrDesc, MessageType.UNKNOWN_TYPE, object));
            }
        }
    }

    private boolean isPrimitive(String string) {
        return Arrays.binarySearch(primitives, string) >= 0;
    }
}

