/*
 * Decompiled with CFR 0.152.
 */
package model.validator.rules;

import java.util.ArrayList;
import java.util.List;
import model.ZephyrDesc;
import model.ZephyrKeyword;
import model.validator.ErrorMessage;
import model.validator.MessageType;
import model.validator.ValidatorMessage;
import model.validator.rules.Rule;

public class FamilyRule
implements Rule {
    private List<String> validFamilies = new ArrayList<String>();

    public FamilyRule() {
        this.validFamilies.add("ontap-c");
        this.validFamilies.add("ontap-d");
        this.validFamilies.add("ontap-cluster");
        this.validFamilies.add("vfiler");
    }

    @Override
    public void check(List<ValidatorMessage> list, ZephyrDesc zephyrDesc, int n) {
        String[] stringArray;
        if (zephyrDesc.getKeyword() != ZephyrKeyword.FAMILY || n > 1) {
            return;
        }
        for (String string : stringArray = zephyrDesc.getValue().split(",")) {
            if (this.validFamilies.contains(string)) continue;
            list.add(new ErrorMessage(zephyrDesc, MessageType.UNKNOWN_FAMILY, zephyrDesc.getValue()));
        }
    }
}

