/*
 * Decompiled with CFR 0.152.
 */
package model.validator.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import model.ZephyrDesc;
import model.ZephyrKeyword;
import model.validator.MessageType;
import model.validator.ValidatorMessage;
import model.validator.rules.Rule;

public class ErrorRule
implements Rule {
    private Map<String, ZephyrDesc> errDefs = new HashMap<String, ZephyrDesc>();
    private Map<String, ZephyrDesc> errNos = new HashMap<String, ZephyrDesc>();

    @Override
    public void check(List<ValidatorMessage> list, ZephyrDesc zephyrDesc, int n) {
        if (zephyrDesc.getKeyword() != ZephyrKeyword.ERRNO && zephyrDesc.getKeyword() != ZephyrKeyword.ERRDEF) {
            return;
        }
        if (n == 1) {
            if (zephyrDesc.getKeyword() == ZephyrKeyword.ERRNO) {
                this.errNos.put(zephyrDesc.getValue(), zephyrDesc);
            }
            if (zephyrDesc.getKeyword() == ZephyrKeyword.ERRDEF) {
                if (this.errDefs.containsKey(zephyrDesc.getValue())) {
                    list.add(new ValidatorMessage(zephyrDesc, MessageType.DUPLICATE_TYPEDEF, zephyrDesc.getValue()));
                } else {
                    this.errDefs.put(zephyrDesc.getValue(), zephyrDesc);
                }
            }
        }
        if (n != 2 || zephyrDesc.getKeyword() != ZephyrKeyword.ERRNO || !this.errDefs.containsKey(zephyrDesc.getValue())) {
            // empty if block
        }
    }
}

