/*
 * Decompiled with CFR 0.152.
 */
package model.validator.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import model.ZephyrDesc;
import model.ZephyrDescList;
import model.ZephyrKeyword;
import model.validator.ErrorMessage;
import model.validator.MessageType;
import model.validator.ValidatorMessage;
import model.validator.rules.AbstractRule;
import model.validator.rules.Rule;

public class ApiRule
extends AbstractRule
implements Rule {
    private Map<String, ZephyrDesc> apis = new HashMap<String, ZephyrDesc>();
    private List<String> checkedIters = new ArrayList<String>();
    private static Pattern p = Pattern.compile("(.+)(-iter-start|-iter-next|-iter-end)$");
    private Set<String> validStatii = new HashSet<String>();

    public ApiRule() {
        this.validStatii.add("supported");
        this.validStatii.add("unsupported");
        this.validStatii.add("public");
    }

    @Override
    public void check(List<ValidatorMessage> list, ZephyrDesc zephyrDesc, int n) {
        if (zephyrDesc.getKeyword() != ZephyrKeyword.API) {
            return;
        }
        if (n == 1) {
            this.apis.put(zephyrDesc.getValue(), zephyrDesc);
        }
        if (n == 2) {
            Object object;
            Object object2;
            Object object32;
            Serializable serializable;
            String string = zephyrDesc.getValue().trim();
            ZephyrDescList zephyrDescList = zephyrDesc.getChildren(ZephyrKeyword.STATUS);
            if (zephyrDescList.size() < 1) {
                list.add(new ErrorMessage(zephyrDesc, MessageType.MISSING_STATUS, string));
            } else if (zephyrDescList.size() > 1) {
                list.add(new ErrorMessage(zephyrDesc, MessageType.MULTIPLE_STATUS, string));
            } else {
                serializable = (ZephyrDesc)zephyrDescList.get(0);
                if (!this.validStatii.contains(((ZephyrDesc)serializable).getValue())) {
                    list.add(new ErrorMessage((ZephyrDesc)serializable, MessageType.UNKNOWN_STATUS, ((ZephyrDesc)serializable).getValue()));
                }
            }
            serializable = new HashSet();
            for (Object object32 : zephyrDesc.getChildren(ZephyrKeyword.INPUT)) {
                if (serializable.contains(((ZephyrDesc)object32).getValue())) {
                    list.add(new ErrorMessage((ZephyrDesc)object32, MessageType.DUPLICATE_INPUT, ((ZephyrDesc)object32).getValue(), string));
                } else {
                    serializable.add(((ZephyrDesc)object32).getValue());
                }
                object2 = ((ZephyrDesc)object32).getChildren(ZephyrKeyword.TYPE);
                if (object2.size() == 0) {
                    list.add(new ErrorMessage((ZephyrDesc)object32, MessageType.MISSING_TYPE, ((ZephyrDesc)object32).getValue()));
                    continue;
                }
                if (object2.size() > 1) {
                    list.add(new ErrorMessage((ZephyrDesc)object32, MessageType.MULTIPLE_TYPES, ((ZephyrDesc)object32).getValue()));
                    continue;
                }
                object = (ZephyrDesc)object2.get(0);
                if (!((ZephyrDesc)object).getValue().equals("integer")) continue;
                this.checkParam((ZephyrDesc)object32, list);
            }
            HashSet hashSet = new HashSet();
            object32 = zephyrDesc.getChildren(ZephyrKeyword.OUTPUT).iterator();
            while (object32.hasNext()) {
                object2 = (ZephyrDesc)object32.next();
                if (hashSet.contains(((ZephyrDesc)object2).getValue())) {
                    list.add(new ErrorMessage((ZephyrDesc)object2, MessageType.DUPLICATE_OUTPUT, ((ZephyrDesc)object2).getValue(), string));
                } else {
                    hashSet.add(((ZephyrDesc)object2).getValue());
                }
                object = ((ZephyrDesc)object2).getChildren(ZephyrKeyword.TYPE);
                if (object.size() == 0) {
                    list.add(new ErrorMessage((ZephyrDesc)object2, MessageType.MISSING_TYPE, ((ZephyrDesc)object2).getValue()));
                    continue;
                }
                if (object.size() > 1) {
                    list.add(new ErrorMessage((ZephyrDesc)object2, MessageType.MULTIPLE_TYPES, ((ZephyrDesc)object2).getValue()));
                    continue;
                }
                ZephyrDesc zephyrDesc2 = (ZephyrDesc)object.get(0);
                if (!zephyrDesc2.getValue().equals("integer")) continue;
                this.checkParam((ZephyrDesc)object2, list);
            }
            if (zephyrDesc.getChildren(ZephyrKeyword.DESC).size() == 0) {
                list.add(new ErrorMessage(zephyrDesc, MessageType.MISSING_DESC, string));
            }
            if (zephyrDesc.getChildren(ZephyrKeyword.NAMESPACE).size() > 1) {
                list.add(new ErrorMessage(zephyrDesc, MessageType.MULTIPLE_NAMESPACES, string));
            }
            if (zephyrDesc.getChildren(ZephyrKeyword.NAMESPACE).size() < 1) {
                list.add(new ErrorMessage(zephyrDesc, MessageType.MISSING_NAMESPACE, string));
            }
            if (string.matches(".*[^a-z\\d-]+.*")) {
                list.add(new ErrorMessage(zephyrDesc, MessageType.INVALID_API_NAME, string));
            }
            if (string.endsWith("-iter")) {
                this.checkForTagInput(list, zephyrDesc, string);
            }
            if (string.endsWith("-iter-next")) {
                this.checkForRecordsOutput(list, zephyrDesc, string);
            }
            if ((object32 = zephyrDesc.getParent()) == null) {
                list.add(new ErrorMessage(zephyrDesc, MessageType.MISSING_CATEGORY, string));
            } else if (!string.matches("(" + ((ZephyrDesc)object32).getValue() + ").+")) {
                list.add(new ErrorMessage(zephyrDesc, MessageType.API_CATEGORY_MISMATCH, string, ((ZephyrDesc)object32).getValue()));
            }
            object2 = p.matcher(string);
            if (((Matcher)object2).matches()) {
                object = ((Matcher)object2).group(1);
                if (string.matches("(.*)(-iter-next|-iter-end)$")) {
                    this.checkForTagInput(list, zephyrDesc, string);
                }
                if (!this.checkedIters.contains(object)) {
                    if (!this.apis.containsKey((String)object + "-iter-start")) {
                        list.add(new ErrorMessage(zephyrDesc, MessageType.MISSING_ITER_START, string, object));
                    }
                    if (!this.apis.containsKey((String)object + "-iter-next")) {
                        list.add(new ErrorMessage(zephyrDesc, MessageType.MISSING_ITER_NEXT, string, object));
                    }
                    if (!this.apis.containsKey((String)object + "-iter-end")) {
                        list.add(new ErrorMessage(zephyrDesc, MessageType.MISSING_ITER_END, string, object));
                    }
                    this.checkedIters.add((String)object);
                }
            }
        }
    }

    private void checkForRecordsOutput(List<ValidatorMessage> list, ZephyrDesc zephyrDesc, String string) {
        ZephyrDescList zephyrDescList = zephyrDesc.getChildren(ZephyrKeyword.OUTPUT);
        boolean bl = false;
        for (ZephyrDesc zephyrDesc2 : zephyrDescList) {
            if (!zephyrDesc2.getValue().equals("records")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            list.add(new ErrorMessage(zephyrDesc, MessageType.MISSING_RECORDS_ELEMENT, new Object[0]));
        }
    }

    private void checkForTagInput(List<ValidatorMessage> list, ZephyrDesc zephyrDesc, String string) {
        ZephyrDescList zephyrDescList = zephyrDesc.getChildren(ZephyrKeyword.INPUT);
        if (zephyrDescList.size() == 0) {
            list.add(new ErrorMessage(zephyrDesc, MessageType.MISSING_TAG_ELEMENT, new Object[0]));
        } else {
            boolean bl = false;
            for (ZephyrDesc zephyrDesc2 : zephyrDescList) {
                if (!zephyrDesc2.getValue().equals("tag")) continue;
                bl = true;
            }
            if (!bl) {
                list.add(new ErrorMessage(zephyrDesc, MessageType.MISSING_TAG_ELEMENT, new Object[0]));
            }
        }
    }
}

