/*
 * Decompiled with CFR 0.152.
 */
package model.generator;

import java.util.List;
import model.generator.Generator;
import model.generator.Param;
import model.generator.SimpleParam;
import model.generator.TypeParam;

public class PythonGenerator
implements Generator {
    StringBuffer code = new StringBuffer(1000);
    boolean hasParameters;
    private boolean hasTypes;

    @Override
    public String generateText(Object object) {
        return this.code.toString();
    }

    @Override
    public void addComment(Object object, String string) {
        this.code.append("\n");
        this.code.append("# " + string + "\n");
    }

    @Override
    public Object addSimpleParameter(Object object, String string, String string2) {
        return null;
    }

    @Override
    public Object addTypeParameter(Object object, String string) {
        return null;
    }

    @Override
    public Object beginOutput() {
        this.code.append("from pyzapi import session\n");
        this.code.append("# Find out more about pyzapi here: http://web.netapp.com/~ryanc/pyzapi/index.html\n\n");
        this.code.append("def dump(e,depth=0):\n");
        this.code.append("    print \"%s%s : %s\" % ( '  '*depth,e.tag,e.text)\n");
        this.code.append("    [ dump(c,depth+1) for c in e  ]\n\n");
        this.code.append("s = session('10.61.166.13','root','', isSecure=True)\n");
        return null;
    }

    @Override
    public void endOutput(Object object) {
    }

    @Override
    public Object beginAPI(Object object, String string, String string2, boolean bl) {
        if (bl) {
            this.code.append("# " + string2 + "\n");
        }
        if (this.hasParameters) {
            this.code.append("results = s.call( '" + string + "', (");
        } else {
            this.code.append("results = s.call( '" + string + "')\n");
        }
        return null;
    }

    @Override
    public void addParameters(List<Param> list) {
        if (list.size() > 0) {
            this.genParameters(list, 0);
            this.code.append(")\n");
        }
    }

    private void genParameters(List<Param> list, int n) {
        Param param = list.get(list.size() - 1);
        for (Param param2 : list) {
            this.code.append("\n");
            for (int i = 0; i < n + 1; ++i) {
                this.code.append("    ");
            }
            if (param2 instanceof SimpleParam) {
                SimpleParam simpleParam = (SimpleParam)param2;
                this.code.append("('" + simpleParam.name + "','" + simpleParam.value + "')");
            }
            if (param2 instanceof TypeParam) {
                TypeParam typeParam = (TypeParam)param2;
                this.code.append("('" + typeParam.name + "', ");
                this.genParameters(typeParam.params, n + 1);
            }
            if (param2 == param) continue;
            this.code.append(",");
        }
        this.code.append(")");
    }

    @Override
    public void endAPI(Object object) {
        this.code.append("\n# Use find/findtext to pull out elements of interest\n");
        this.code.append("# output = results.findtext('results/foo/bar')\n");
        this.code.append("# here we just dump out all of the tree for demonstration purposes\n\n");
        this.code.append("dump(results)\n");
    }

    @Override
    public boolean isSingleLineMode(List<Param> list) {
        this.hasParameters = list.size() > 0;
        this.hasTypes = false;
        for (Param param : list) {
            if (!(param instanceof TypeParam)) continue;
            this.hasTypes = true;
            break;
        }
        return true;
    }
}

