/*
 * Decompiled with CFR 0.152.
 */
package model.generator;

import java.util.HashMap;
import java.util.List;
import model.generator.Generator;
import model.generator.Param;
import zexplore.View;
import zexplore.menubar.MenuBar;

public class PerlGenerator
implements Generator {
    StringBuffer code = new StringBuffer(1000);
    int numVars = 0;
    private View view;
    private HashMap<String, String> elementMap = new HashMap();

    public PerlGenerator(View view) {
        this.view = view;
    }

    @Override
    public String generateText(Object object) {
        return this.code.toString();
    }

    @Override
    public void addComment(Object object, String string) {
        this.code.append("\n");
        this.code.append("# " + string + "\n");
    }

    @Override
    public Object addSimpleParameter(Object object, String string, String string2) {
        if (string2.isEmpty()) {
            string2 = "<" + string + ">";
        }
        this.code.append(object + "->child_add_string('" + string + "','" + string2 + "');\n");
        return object;
    }

    @Override
    public Object addTypeParameter(Object object, String string) {
        String string2;
        String string3 = "$xi" + this.numVars;
        String string4 = null;
        if (this.numVars == 0) {
            string3 = "$xi";
        } else {
            string4 = this.numVars == 1 ? "$xi" : "$xi" + (this.numVars - 1);
        }
        if (string4 != null && (string2 = this.elementMap.get(string4)) != null && string2.equals(string)) {
            return string4;
        }
        ++this.numVars;
        this.code.append("\n");
        this.code.append("my " + string3 + " = new NaElement('" + string + "');\n");
        this.code.append(object + "->child_add(" + string3 + ");\n");
        this.elementMap.put(string3, string);
        return string3;
    }

    @Override
    public Object beginOutput() {
        this.code.append("require 5.6.1;\n");
        this.code.append("use lib '<path_to_nmsdk_root>/lib/perl/NetApp';\n");
        this.code.append("use strict;\n");
        this.code.append("use warnings;\n");
        this.code.append("use NaServer;\n");
        this.code.append("use NaElement;\n");
        this.code.append("\n\n");
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "FILER";
        String string5 = "HTTP";
        String string6 = "80";
        String string7 = "1";
        String string8 = "0";
        boolean bl = false;
        boolean bl2 = false;
        if (MenuBar.preferencesMenu.getServerType().equals("ontap")) {
            string = MenuBar.preferencesMenu.getHostName();
            string2 = MenuBar.preferencesMenu.getUserName();
            string5 = MenuBar.preferencesMenu.getProtocol();
            string6 = MenuBar.preferencesMenu.getPort();
            string3 = MenuBar.preferencesMenu.getVfilerName();
            String string9 = "ontapi_1.13";
            if (string9.contains("Mode") || string9.contains("Vserver")) {
                bl2 = true;
                string9 = string9.replaceAll("_Cluster_Mode", "");
                string9 = string9.replaceAll("_Vserver", "");
                string9 = string9.replaceAll("_7_Mode", "");
            }
            String[] stringArray = string9.split("\\.");
            string7 = stringArray[0];
            string8 = stringArray[1];
            if (string3.length() > 0) {
                int n = Integer.parseInt(string7);
                int n2 = Integer.parseInt(string8);
                if (n == 1 && n2 < 7) {
                    string8 = "7";
                    bl = true;
                }
            }
        } else if (MenuBar.preferencesMenu.getServerType().equals("dfm")) {
            string4 = "DFM";
            string = MenuBar.preferencesMenu.getHostName();
            string2 = MenuBar.preferencesMenu.getUserName();
            string5 = MenuBar.preferencesMenu.getProtocol();
            string6 = MenuBar.preferencesMenu.getPort();
        }
        if (string.isEmpty()) {
            string = "<server name or IP address>";
        }
        if (string2.isEmpty()) {
            string2 = "<user name>";
        }
        this.code.append("my $server = '" + string + "';\n");
        this.code.append("my $user = '" + string2 + "';\n");
        this.code.append("my $password = '<password>';\n");
        if (string4.equals("FILER") && string3.length() > 0) {
            this.code.append("my $vfiler = '" + string3 + "';\n");
        }
        this.code.append("my $port = '" + string6 + "';\n\n");
        if (bl) {
            this.code.append("# Version must be at least 1.7 to send API to a vfiler\n");
        }
        this.code.append("my $s = new NaServer($server, " + string7 + ", " + string8 + ");\n");
        this.code.append("$s->set_style('LOGIN');\n");
        this.code.append("$s->set_admin_user($user, $password);\n");
        this.code.append("$s->set_transport_type('" + string5 + "');\n");
        this.code.append("$s->set_server_type('" + string4 + "');\n");
        this.code.append("$s->set_port($port);\n");
        if (string4.equals("FILER") && string3.length() > 0) {
            if (bl2) {
                this.code.append("$s->set_vserver($vfiler);\n");
            } else {
                this.code.append("$s->set_vfiler($vfiler);\n");
            }
        }
        this.code.append("\n");
        return "$s";
    }

    @Override
    public void endOutput(Object object) {
    }

    @Override
    public Object beginAPI(Object object, String string, String string2, boolean bl) {
        if (bl) {
            this.code.append("# " + string2 + "\n");
        }
        this.code.append("my $api = new NaElement('" + string + "');\n");
        return "$api";
    }

    @Override
    public void endAPI(Object object) {
        this.code.append("\n");
        this.code.append("\n");
        this.code.append("print 'Calling:\\n';\n");
        this.code.append("print $api->sprintf();\n");
        this.code.append("my $r = $s->invoke_elem($api);\n");
        this.code.append("if ($r->results_status() eq 'failed') {\n");
        this.code.append("    print 'Error:\\n';\n");
        this.code.append("    print $r->sprintf();\n");
        this.code.append("    exit 1;\n");
        this.code.append("}\n");
        this.code.append("\n");
        this.code.append("print 'Received:\\n';\n");
        this.code.append("print $r->sprintf();\n");
    }

    @Override
    public void addParameters(List<Param> list) {
    }

    @Override
    public boolean isSingleLineMode(List<Param> list) {
        return false;
    }
}

