/*
 * Decompiled with CFR 0.152.
 */
package model.generator;

import java.util.HashMap;
import java.util.List;
import model.generator.Generator;
import model.generator.Param;
import zexplore.View;
import zexplore.menubar.MenuBar;

public class JavaGenerator
implements Generator {
    private View view;
    private HashMap<String, String> elementMap = new HashMap();
    StringBuffer code = new StringBuffer(1000);
    int numVars = 0;

    public JavaGenerator(View view) {
        this.view = view;
    }

    @Override
    public String generateText(Object object) {
        return this.code.toString();
    }

    @Override
    public void addComment(Object object, String string) {
        this.code.append("\n");
        this.code.append("\t\t\t// " + string + "\n");
    }

    @Override
    public Object addSimpleParameter(Object object, String string, String string2) {
        if (string2.isEmpty()) {
            string2 = "<" + string + ">";
        }
        this.code.append("\t\t\t" + object + ".addNewChild(\"" + string + "\",\"" + string2 + "\");\n");
        return object;
    }

    @Override
    public Object addTypeParameter(Object object, String string) {
        String string2;
        String string3 = "xi" + this.numVars;
        String string4 = null;
        if (this.numVars == 0) {
            string3 = "xi";
        } else {
            string4 = this.numVars == 1 ? "xi" : "xi" + (this.numVars - 1);
        }
        if (string4 != null && (string2 = this.elementMap.get(string4)) != null && string2.equals(string)) {
            return string4;
        }
        ++this.numVars;
        this.code.append("\n");
        this.code.append("\t\t\tNaElement " + string3 + " = new NaElement( \"" + string + "\" );\n");
        this.code.append("\t\t\t" + object + ".addNewChild(" + string3 + ");\n");
        this.elementMap.put(string3, string);
        return string3;
    }

    @Override
    public Object beginOutput() {
        this.code.append("import java.io.IOException;\n");
        this.code.append("import java.net.UnknownHostException;\n");
        this.code.append("import java.util.List;\n");
        this.code.append("\n");
        this.code.append("import netapp.manage.NaElement;\n");
        this.code.append("import netapp.manage.NaException;\n");
        this.code.append("import netapp.manage.NaServer;\n");
        this.code.append("\n");
        this.code.append("public class ZapiClient {\n");
        this.code.append("\n");
        this.code.append("\tpublic static void main(String[] args) {\n");
        this.code.append("\t\ttry {\n");
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "NaServer.SERVER_TYPE_FILER";
        String string5 = "NaServer.TRANSPORT_TYPE_";
        String string6 = "HTTP";
        String string7 = "80";
        String string8 = "1";
        String string9 = "0";
        boolean bl = false;
        boolean bl2 = false;
        if (MenuBar.preferencesMenu.getServerType().equals("ontap")) {
            string = MenuBar.preferencesMenu.getHostName();
            string2 = MenuBar.preferencesMenu.getUserName();
            string6 = MenuBar.preferencesMenu.getProtocol();
            string5 = string5 + string6;
            string7 = MenuBar.preferencesMenu.getPort();
            string3 = MenuBar.preferencesMenu.getVfilerName();
            String string10 = "ontapi_1_13";
            if (string10.contains("Mode") || string10.contains("Vserver")) {
                bl2 = true;
                string10 = string10.replaceAll("_Cluster_Mode", "");
                string10 = string10.replaceAll("_Vserver", "");
                string10 = string10.replaceAll("_7_Mode", "");
            }
            String[] stringArray = string10.split("\\.");
            string8 = stringArray[0];
            string9 = stringArray[1];
            if (string3.length() > 0) {
                int n = Integer.parseInt(string8);
                int n2 = Integer.parseInt(string9);
                if (n == 1 && n2 < 7) {
                    string9 = "7";
                    bl = true;
                }
            }
        } else if (MenuBar.preferencesMenu.getServerType().equals("dfm")) {
            string4 = "NaServer.SERVER_TYPE_DFM";
            string = MenuBar.preferencesMenu.getHostName();
            string2 = MenuBar.preferencesMenu.getUserName();
            string6 = MenuBar.preferencesMenu.getProtocol();
            string5 = string5 + string6;
            string7 = MenuBar.preferencesMenu.getPort();
        }
        if (string.isEmpty()) {
            string = "<server name or IP address>";
        }
        if (string2.isEmpty()) {
            string2 = "<user name>";
        }
        if (bl) {
            this.code.append("       // Version must be at least 1.7 to send API to a vfiler\n");
        }
        this.code.append("\t\t\tNaServer s = new NaServer(\"" + string + "\", " + string8 + " , " + string9 + ");\n");
        this.code.append("\t\t\ts.setServerType(" + string4 + ");\n");
        this.code.append("\t\t\ts.setTransportType(" + string5 + ");\n");
        this.code.append("\t\t\ts.setPort(" + string7 + ");\n");
        this.code.append("\t\t\ts.setStyle(NaServer.STYLE_LOGIN_PASSWORD);\n");
        this.code.append("\t\t\ts.setAdminUser(\"" + string2 + "\", \"<password>\");\n");
        if (string4.equals("NaServer.SERVER_TYPE_FILER") && string3.length() > 0) {
            if (bl2) {
                this.code.append("\t\t\ts.setVserverTunneling(\"" + string3 + "\");\n");
            } else {
                this.code.append("\t\t\ts.setVfilerTunneling(\"" + string3 + "\");\n");
            }
        }
        this.code.append("\n");
        this.code.append("\n");
        return "s";
    }

    @Override
    public void endOutput(Object object) {
    }

    @Override
    public Object beginAPI(Object object, String string, String string2, boolean bl) {
        if (bl) {
            this.code.append("       // " + string2 + "\n");
        }
        this.code.append("\t\t\tNaElement api = new NaElement(\"" + string + "\");\n");
        return "api";
    }

    @Override
    public void endAPI(Object object) {
        this.code.append("\n");
        this.code.append("\n");
        this.code.append("\t\t\tNaElement xo = s.invokeElem(api);\n");
        this.code.append("\t\t\tSystem.out.println(xo.getAttr(\"status\"));\n");
        this.code.append("\t\t\tList<NaElement> children = xo.getChildren();\n");
        this.code.append("\t\t\tfor (NaElement child : children) {\n");
        this.code.append("\t\t\t\tSystem.out.println(child.getName() + \":\" + child.getContent());\n");
        this.code.append("\t\t\t}\n");
        this.code.append("\t\t} catch (NaException e) {\n");
        this.code.append("\t\t\thandleException(e);\n");
        this.code.append("\t\t} catch (UnknownHostException e) {\n");
        this.code.append("\t\t\thandleException(e);\n");
        this.code.append("\t\t} catch (IOException e) {\n");
        this.code.append("\t\t\thandleException(e);\n");
        this.code.append("\t\t}\n");
        this.code.append("\t}\n");
        this.code.append("\tprivate static void handleException(Exception e) {\n");
        this.code.append("\t\tSystem.out.println(e.getMessage());\n");
        this.code.append("\t\te.printStackTrace();\t\t\n");
        this.code.append("\t}\n");
        this.code.append("}\n");
    }

    @Override
    public void addParameters(List<Param> list) {
    }

    @Override
    public boolean isSingleLineMode(List<Param> list) {
        return false;
    }
}

