/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.Serializable;
import java.util.HashMap;
import model.Visitor;
import model.ZephyrDescList;
import model.ZephyrKeyword;
import model.ZephyrKeywordList;

public class ZephyrDesc
implements Comparable<ZephyrDesc>,
Serializable {
    private static final long serialVersionUID = -9168971760127461302L;
    private ZephyrDescList children = new ZephyrDescList();
    private HashMap<ZephyrKeyword, ZephyrDescList> childrenMap;
    private ZephyrKeywordList validChildKeywords;
    private ZephyrKeyword keyword;
    private StringBuffer value = new StringBuffer();
    private ZephyrDesc parent;
    private int lineNumber;

    public ZephyrDesc(ZephyrKeyword zephyrKeyword, int n, ZephyrKeyword ... zephyrKeywordArray) {
        this.keyword = zephyrKeyword;
        this.lineNumber = n;
        this.validChildKeywords = new ZephyrKeywordList();
        for (ZephyrKeyword zephyrKeyword2 : zephyrKeywordArray) {
            this.validChildKeywords.add(zephyrKeyword2);
        }
    }

    public void addValidChildKeyword(ZephyrKeyword zephyrKeyword) {
        this.validChildKeywords.add(zephyrKeyword);
    }

    public ZephyrDescList getChildren(ZephyrKeyword zephyrKeyword) {
        ZephyrDescList zephyrDescList = this.getChildrenMap().get((Object)zephyrKeyword);
        if (zephyrDescList == null) {
            return new ZephyrDescList();
        }
        return zephyrDescList;
    }

    public boolean hasChild(ZephyrKeyword zephyrKeyword) {
        return this.getChildrenMap().containsKey((Object)this.keyword);
    }

    private HashMap<ZephyrKeyword, ZephyrDescList> getChildrenMap() {
        if (this.childrenMap == null) {
            this.childrenMap = new HashMap();
        }
        return this.childrenMap;
    }

    public ZephyrDescList getChildren() {
        return this.children;
    }

    public void setChildren(ZephyrDescList zephyrDescList) {
        this.children = zephyrDescList;
    }

    public boolean isValidChild(ZephyrDesc zephyrDesc) {
        if (this.keyword == ZephyrKeyword.ROOT) {
            return true;
        }
        ZephyrKeyword zephyrKeyword = zephyrDesc.getKeyword();
        return this.validChildKeywords.contains((Object)zephyrKeyword);
    }

    public void addChild(ZephyrDesc zephyrDesc) {
        if (!this.isValidChild(zephyrDesc)) {
            throw new IllegalArgumentException("child " + (Object)((Object)zephyrDesc.getKeyword()) + " cannot be" + " a child of " + (Object)((Object)this.getKeyword()) + " at line: " + this.lineNumber);
        }
        ZephyrKeyword zephyrKeyword = zephyrDesc.getKeyword();
        if (!this.getChildrenMap().containsKey((Object)zephyrKeyword)) {
            this.getChildrenMap().put(zephyrKeyword, new ZephyrDescList());
        }
        ZephyrDescList zephyrDescList = this.getChildrenMap().get((Object)zephyrKeyword);
        zephyrDescList.add(zephyrDesc);
        this.children.add(zephyrDesc);
        zephyrDesc.setParent(this);
    }

    public void removeChild(ZephyrDesc zephyrDesc) {
        ZephyrKeyword zephyrKeyword = zephyrDesc.getKeyword();
        ZephyrDescList zephyrDescList = this.getChildrenMap().get((Object)zephyrKeyword);
        zephyrDescList.remove(zephyrDesc);
        this.children.remove(zephyrDesc);
    }

    public void setParent(ZephyrDesc zephyrDesc) {
        this.parent = zephyrDesc;
    }

    public ZephyrDesc getParent() {
        return this.parent;
    }

    public ZephyrKeyword getKeyword() {
        return this.keyword;
    }

    public String getValue() {
        return this.value.toString();
    }

    public int hashCode() {
        return this.getValue().hashCode() + this.getKeyword().hashCode() + 31 * this.getLineNumber();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        ZephyrDesc zephyrDesc = (ZephyrDesc)object;
        return this.getKeyword() == zephyrDesc.getKeyword() && this.getValue().equals(zephyrDesc.getValue()) && this.getLineNumber() == zephyrDesc.getLineNumber();
    }

    public void setValue(String string) {
        this.value.setLength(0);
        this.value.append(string);
    }

    public String getChildValue(ZephyrKeyword zephyrKeyword) {
        ZephyrDescList zephyrDescList = this.getChildrenMap().get((Object)zephyrKeyword);
        if (zephyrDescList == null || zephyrDescList.size() == 0) {
            return null;
        }
        ZephyrDesc zephyrDesc = (ZephyrDesc)zephyrDescList.get(0);
        return zephyrDesc.getValue();
    }

    public void setChildValue(ZephyrKeyword zephyrKeyword, String string) {
        ZephyrDescList zephyrDescList = this.getChildrenMap().get((Object)zephyrKeyword);
        if (zephyrDescList == null || zephyrDescList.size() == 0) {
            throw new IllegalArgumentException("child for keyword: " + (Object)((Object)zephyrKeyword) + ", does not exist in " + (Object)((Object)this.getKeyword()));
        }
        ZephyrDesc zephyrDesc = (ZephyrDesc)zephyrDescList.get(0);
        zephyrDesc.setValue(string);
    }

    public void appendValue(String string) {
        this.value.append(string);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public ZephyrDesc getRootNode() {
        ZephyrDesc zephyrDesc = this;
        if (this.getParent() != null) {
            zephyrDesc = this.getParent().getRootNode();
        }
        return zephyrDesc;
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public int compareTo(ZephyrDesc zephyrDesc) {
        return this.getValue().compareTo(zephyrDesc.getValue());
    }

    public void visit(Visitor visitor) {
        this.walk(visitor, this, 0);
    }

    void walk(Visitor visitor, ZephyrDesc zephyrDesc, int n) {
        visitor.visit(zephyrDesc, n);
        ZephyrDescList zephyrDescList = zephyrDesc.getChildren();
        for (ZephyrDesc zephyrDesc2 : zephyrDescList) {
            this.walk(visitor, zephyrDesc2, n + 1);
        }
    }
}

