/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions.gui;

import java.awt.Dimension;
import java.util.Arrays;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.gui.EscapeListener;
import jsyntaxpane.util.SwingUtils;

public class ShowAbbsDialog
extends JDialog
implements EscapeListener {
    private JEditorPane jEdtAbbr;
    private JList jLstAbbs;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    Map<String, String> abbs;

    public ShowAbbsDialog(JEditorPane parent, Map<String, String> abbs) {
        super(ActionUtils.getFrameFor(parent), true);
        this.initComponents();
        Object[] abbsList = abbs.keySet().toArray();
        Arrays.sort(abbsList);
        this.jLstAbbs.setListData(abbsList);
        this.abbs = abbs;
        this.jEdtAbbr.setEditorKit(parent.getEditorKit());
        this.jLstAbbs.setSelectedIndex(0);
        SwingUtils.addEscapeListener(this);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jLstAbbs = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jEdtAbbr = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("Abbreviations");
        this.setLocationByPlatform(true);
        this.setMinimumSize(new Dimension(600, 300));
        this.setModal(true);
        this.setName("dlgShowAbbs");
        this.jScrollPane1.setPreferredSize(new Dimension(258, 400));
        this.jLstAbbs.setSelectionMode(0);
        this.jLstAbbs.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ShowAbbsDialog.this.jLstAbbsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jLstAbbs);
        this.jEdtAbbr.setEditable(false);
        this.jEdtAbbr.setMinimumSize(new Dimension(106, 400));
        this.jScrollPane2.setViewportView(this.jEdtAbbr);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 278, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 278, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jLstAbbsValueChanged(ListSelectionEvent evt) {
        Object selected;
        if (!evt.getValueIsAdjusting() && (selected = this.jLstAbbs.getSelectedValue()) != null) {
            this.jEdtAbbr.setText(this.abbs.get(selected));
        }
    }

    @Override
    public void escapePressed() {
        this.setVisible(false);
    }
}

