/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.zapi.parser;

import com.google.common.base.Function;
import com.netapp.nmsdk.common.api.annotation.DocEnum;
import com.netapp.nmsdk.common.logging.MessageKey;
import com.netapp.nmsdk.common.logging.NALogger;
import com.netapp.zapi.generator.GeneratorFactory;
import com.netapp.zapi.generator.NameGenerator;
import com.netapp.zapi.parser.Api;
import com.netapp.zapi.parser.IncompatibleFieldsException;
import com.netapp.zapi.parser.MsgKey;
import com.netapp.zapi.parser.Tag;
import com.netapp.zapi.parser.Type;
import com.netapp.zapi.parser.Typedef;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

@SuppressWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
public class Field
implements Comparable<Field> {
    private static final NALogger logger = NALogger.getLogger(Field.class);
    static final Pattern DESC_RANGE_PATTERN = Pattern.compile("Range\\s*:\\s*(\\[[^\\]]+\\])");
    static final Pattern PARSE_RANGE_PATTERN = Pattern.compile("(?:^|\\[)(\\-?(?:\\d+|2\\^\\d+(?:-1)?))\\s*(?:-|\\.\\.)\\s*(\\-?(?:\\d+|2\\^\\d+(?:-1)?))(?:\\]|$)");
    static final Pattern PARSE_RANGE_ARG = Pattern.compile("(-?\\d+)|(-)?2\\^(\\d+)(-1)?");
    static final int PARSE_RANGE_LITERAL_GROUP = 1;
    static final int PARSE_RANGE_EXP_NEGATE_GROUP = 2;
    static final int PARSE_RANGE_EXP_GROUP = 3;
    static final int PARSE_RANGE_EXP_MIN_ONE_GROUP = 4;
    static final Pattern DESC_POSSIBLE_VALUES_PATTERN = Pattern.compile("possible values", 2);
    static final Pattern SIGN_MODIFIER = Pattern.compile("((?:un)signed)\\s+(\\S+)");
    public static final Function<Field, String> GET_NAME = new Function<Field, String>(){

        @Override
        public String apply(Field name) {
            return name.name;
        }
    };
    String name;
    String desc;
    String type;
    boolean collection;
    Range range;
    boolean optional;
    boolean encrypted;
    boolean cdata;
    boolean sensitive;
    Collection<String> internableValues;
    DocEnum doc;
    Set<String> scope = new TreeSet<String>();
    Type declaringType;

    public Field(Type declaringType, String name) {
        this.declaringType = declaringType;
        this.name = name;
        this.internableValues = this.declaringType.parser.getInternableValues(this.declaringType.getName(), this.name);
    }

    public String getName() {
        return this.name;
    }

    protected void setDesc(String desc) {
        this.desc = desc;
        java.util.regex.Matcher rangeMatcher = DESC_RANGE_PATTERN.matcher(desc);
        if (rangeMatcher.find()) {
            this.setRange(rangeMatcher.group(1));
        }
        if (this.internableValues == null && DESC_POSSIBLE_VALUES_PATTERN.matcher(desc).find()) {
            this.internableValues = Collections.emptyList();
        }
    }

    public String getDesc() {
        return this.desc;
    }

    public Range getRange() {
        return this.range;
    }

    public DocEnum getDoc() {
        return this.doc;
    }

    public Set<String> getScope() {
        return this.scope;
    }

    private void setRange(String range) {
        java.util.regex.Matcher m = PARSE_RANGE_PATTERN.matcher(range = range.replaceAll("[\\(\\)\\s]", ""));
        if (m.find()) {
            this.range = new Range(m.group(1), m.group(2));
        } else {
            this.declaringType.parser.appendWarning(MsgKey.ZAPI_PARSER_INVALID_RANGE, range, this.name);
        }
    }

    private void setType(String type) {
        java.util.regex.Matcher signMatcher = SIGN_MODIFIER.matcher(type = type.trim().toLowerCase());
        if (signMatcher.matches()) {
            this.declaringType.parser.appendWarning(MsgKey.ZAPI_PARSER_FIELD_MODIFIER_INVALID, signMatcher.group(1), this.name);
            type = signMatcher.group(2);
        }
        boolean newCollection = false;
        if (type.endsWith("[]")) {
            newCollection = true;
            type = type.substring(0, type.length() - 2);
        }
        if (this.type == null) {
            this.type = type;
            this.collection = newCollection;
        } else if (!this.type.equals(type) || this.collection != newCollection) {
            this.declaringType.parser.appendWarning(MsgKey.ZAPI_PARSER_FIELD_TYPE_REDEFINED, this.declaringType, this.name, this.type, type);
        }
    }

    private void setDoc(DocEnum doc) {
        this.doc = doc;
    }

    private void addScope(String scope) {
        if ("cluster".equals(scope)) {
            this.scope.add("ontap-cluster");
        } else {
            this.scope.add(scope);
        }
    }

    public Type getDeclaringType() {
        return this.declaringType;
    }

    public String getType() {
        return this.type;
    }

    public Type getTypedefType() {
        return this.declaringType.getNamespace().getType(this.type);
    }

    public boolean isCollection() {
        return this.collection;
    }

    void populate(Queue<Tag> q) {
        logger.internal("Processing Field " + this.name);
        Tag tag = q.peek();
        block10: while (tag != null) {
            switch (tag.getType()) {
                case DESC: {
                    this.setDesc(tag.getValue());
                    break;
                }
                case TYPE: {
                    String[] words = tag.getValue().split(",");
                    this.setType(words[0]);
                    this.type = this.type.trim();
                    for (int i = 1; i < words.length; ++i) {
                        if (words[i].trim().equalsIgnoreCase("optional")) {
                            this.optional = true;
                            continue;
                        }
                        if (words[i].trim().equalsIgnoreCase("encrypted")) {
                            this.encrypted = true;
                            continue;
                        }
                        if (words[i].trim().equalsIgnoreCase("cdata")) {
                            this.cdata = true;
                            continue;
                        }
                        if (!words[i].trim().equalsIgnoreCase("sensitive")) continue;
                        this.sensitive = true;
                    }
                    break;
                }
                case RANGE: {
                    this.setRange(tag.getValue());
                    break;
                }
                case DOC: {
                    try {
                        this.setDoc(DocEnum.parse(tag.getValue()));
                    }
                    catch (IllegalArgumentException e) {
                        this.declaringType.parser.appendWarning(MsgKey.ZAPI_PARSER_FIELD_DOC_TYPE_UNKNOWN, tag.getValue(), this.name);
                    }
                    break;
                }
                case SCOPE: {
                    String[] scopes;
                    for (String s : scopes = tag.getValue().split(",")) {
                        this.addScope(s.trim());
                    }
                    break;
                }
                case ATTRIBUTE: 
                case REMARK: {
                    break;
                }
                default: {
                    logger.internal("Stopping Field on " + (Object)((Object)tag.getType()));
                    break block10;
                }
            }
            q.poll();
            tag = q.peek();
        }
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean isCDATA() {
        return this.cdata;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public boolean isInternable() {
        return this.internableValues != null;
    }

    public Collection<String> getInternableValues() {
        return this.isInternable() ? Collections.unmodifiableCollection(this.internableValues) : null;
    }

    public boolean isChainable() {
        return true;
    }

    public void addWordReplacements(GeneratorFactory<?, ?, ?, ?> generatorFactory) {
        generatorFactory.getDescriptionGenerator().addWordReplacement(this.name, ((NameGenerator)generatorFactory.getFieldGenerator(this)).getNameGenerated());
    }

    @Override
    public int compareTo(Field obj) {
        return this.name.compareTo(obj.name);
    }

    public String toString() {
        return this.type + " " + this.name;
    }

    void assertEquivalentTo(Field that) throws IncompatibleFieldsException {
        this.assertThat(this.name, Matchers.equalTo(that.name), that, "name");
        this.assertThat(this.type, Matchers.equalTo(that.type), that, "type");
        this.assertThat(this.collection, Matchers.equalTo(that.collection), that, "collection?");
        this.assertThat(this.encrypted, Matchers.equalTo(that.encrypted), that, "encrypted");
        this.assertThat(this.cdata, Matchers.equalTo(that.cdata), that, "cdata");
        this.assertThat(this.sensitive, Matchers.equalTo(that.sensitive), that, "sensitive");
        this.assertThat(this.doc, Matchers.equalTo(that.doc), that, "doc");
        this.checkThat(this.desc, Matchers.equalTo(that.desc), that, "desc");
        this.checkThat(this.range, Matchers.equalTo(that.range), that, "range");
        this.checkThat(this.optional, Matchers.equalTo(that.optional), that, "optional");
    }

    private <T> void checkThat(T actual, Matcher<? super T> matcher, Field that, String fieldAttribute) {
        block2: {
            try {
                this.assertThat(actual, matcher, that, fieldAttribute);
            }
            catch (IncompatibleFieldsException e) {
                if (!this.declaringType.parser.isPrintLogEnabled()) break block2;
                logger.warn((MessageKey)MsgKey.ZAPI_PARSER_INCOMPATIBLE_DUPLICATE_TYPES, this.getDeclaringType().getQualifiedName(), that.getDeclaringType().getQualifiedName(), e.getLocalizedMessage());
            }
        }
    }

    private <T> void assertThat(T actual, Matcher<? super T> matcher, Field that, String fieldAttribute) throws IncompatibleFieldsException {
        if (!matcher.matches(actual)) {
            StringDescription description = new StringDescription();
            description.appendText(String.format("%s.%s:%s <> %s.%s:%s: Expected: ", this.declaringType.getQualifiedName(), this.name, fieldAttribute, that.declaringType.getQualifiedName(), that.name, fieldAttribute)).appendDescriptionOf(matcher).appendText(" but: ");
            matcher.describeMismatch(actual, description);
            throw new IncompatibleFieldsException(this, that, description.toString());
        }
    }

    public boolean isApiField() {
        return this instanceof Api.ApiField;
    }

    public Api.ApiField asApiField() {
        return (Api.ApiField)this;
    }

    public boolean isTypedefField() {
        return this instanceof Typedef.TypedefField;
    }

    public Typedef.TypedefField asTypedefField() {
        return (Typedef.TypedefField)this;
    }

    public class Range {
        private final String min;
        private final String max;
        private final BigInteger minInteger;
        private final BigInteger maxInteger;

        Range(String min, String max) {
            this.min = min;
            this.minInteger = this.expand(min);
            this.max = max;
            this.maxInteger = this.expand(max);
        }

        public String getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        public BigInteger getMinInteger() {
            return this.minInteger;
        }

        public BigInteger getMaxInteger() {
            return this.maxInteger;
        }

        public int getBitCount() {
            return Math.max(this.minInteger.bitLength(), this.maxInteger.bitLength()) + 1;
        }

        private BigInteger expand(String num) {
            BigInteger result;
            java.util.regex.Matcher m = PARSE_RANGE_ARG.matcher(num);
            if (m.matches()) {
                if (m.group(1) != null) {
                    result = new BigInteger(m.group(1));
                } else {
                    int exponent = Integer.parseInt(m.group(3));
                    result = new BigInteger("2").pow(exponent);
                    if (m.group(2) != null) {
                        result = result.negate();
                    }
                    if (m.group(4) != null) {
                        result = result.subtract(BigInteger.ONE);
                    }
                }
            } else {
                Field.this.getDeclaringType().parser.appendError(MsgKey.ZAPI_PARSER_INVALID_RANGE_COMPONENT, num, Field.this.name);
                result = BigInteger.ZERO;
            }
            return result;
        }

        public String toString() {
            return String.format("Range[%s - %s]", this.min, this.max);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.min).append(this.max).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Range)) {
                return false;
            }
            Range that = (Range)obj;
            return new EqualsBuilder().append(this.min, that.min).append(this.max, that.max).isEquals();
        }
    }
}

