/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.zapi.parser;

import com.netapp.nmsdk.common.api.annotation.StatusEnum;
import com.netapp.nmsdk.common.logging.MessageKey;
import com.netapp.nmsdk.common.logging.NALogger;
import com.netapp.zapi.generator.GeneratorFactory;
import com.netapp.zapi.generator.NameGenerator;
import com.netapp.zapi.parser.Field;
import com.netapp.zapi.parser.IncompatibleTypesException;
import com.netapp.zapi.parser.MsgKey;
import com.netapp.zapi.parser.Tag;
import com.netapp.zapi.parser.Type;
import com.netapp.zapi.parser.Typedef;
import com.netapp.zapi.parser.ZapidocParser;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.builder.CompareToBuilder;

public class Api
extends Type {
    public static final String ITER_FIELD_NAME_TAG = "tag";
    public static final String ITER_FIELD_NAME_RECORDS = "records";
    public static final String ITER_FIELD_NAME_MAXIMUM = "maximum";
    private static final String GET_ITER_FIELD_NAME_QUERY = "query";
    private static final String GET_ITER_FIELD_NAME_DESIRED_ATTRIBUTES = "desired-attributes";
    private static final String FAMILY_CMODE = "ontap-cluster";
    private static final NALogger logger = NALogger.getLogger(Api.class);
    StatusEnum status = StatusEnum.UNSUPPORTED;
    Set<String> family = new TreeSet<String>();
    Set<String> errno = new TreeSet<String>();

    public Api(ZapidocParser parser, String name) {
        super(parser, name);
    }

    public ApiField getField(String fieldName, boolean input, boolean output) {
        ApiField field = null;
        for (Field f : this.fields) {
            if (!fieldName.equals(f.getName()) || ((ApiField)f).input != input || ((ApiField)f).output != output) continue;
            field = (ApiField)f;
            break;
        }
        return field;
    }

    public Collection<Field> getInputFields() {
        ArrayList<Field> results = new ArrayList<Field>();
        for (Field f : this.fields) {
            if (!((ApiField)f).input) continue;
            results.add(f);
        }
        return results;
    }

    public Collection<Field> getOutputFields() {
        ArrayList<Field> results = new ArrayList<Field>();
        for (Field f : this.fields) {
            if (!((ApiField)f).output) continue;
            results.add(f);
        }
        return results;
    }

    private void addField(ApiField field) {
        ApiField existing = this.getField(field.getName(), field.input, field.output);
        if (existing != null) {
            if (this.parser.isPrintLogEnabled()) {
                logger.error((MessageKey)MsgKey.ZAPI_PARSER_API_FIELD_DEFINED_TWICE, field.getName(), this.getName());
            }
        } else {
            this.fields.add(field);
        }
    }

    public boolean hasMultipleFieldsNamed(String name) {
        boolean foundOne = false;
        for (Field f : this.fields) {
            if (!f.getName().equals(name)) continue;
            if (foundOne) {
                return true;
            }
            foundOne = true;
        }
        return false;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    protected void setStatus(String status) {
        try {
            this.status = StatusEnum.parse(status);
        }
        catch (IllegalArgumentException e) {
            this.parser.appendError(MsgKey.ZAPI_PARSER_API_STATUS_TYPE_UNKNOWN, status, this);
        }
    }

    @Override
    public void populate(Queue<Tag> q) {
        logger.internal("Processing Api " + this.name);
        Tag tag = q.peek();
        block11: while (tag != null) {
            ApiField field = null;
            Typedef typedef = null;
            switch (tag.getType()) {
                case DESC: {
                    this.setDesc(tag.getValue());
                    break;
                }
                case NAMESPACE: {
                    this.setNamespace(tag.getValue());
                    break;
                }
                case STATUS: {
                    this.setStatus(tag.getValue());
                    break;
                }
                case FAMILY: {
                    for (String f : tag.getValue().split(",")) {
                        this.family.add(f.trim());
                    }
                    break;
                }
                case ERRNO: {
                    this.errno.add(tag.getFirstWord());
                    break;
                }
                case INPUT: {
                    field = new ApiField(tag.getFirstWord());
                    field.input = true;
                    break;
                }
                case OUTPUT: {
                    field = new ApiField(tag.getFirstWord());
                    field.output = true;
                    break;
                }
                case TYPEDEF: {
                    typedef = new Typedef(this.parser, tag.getFirstWord());
                    break;
                }
                case ATTRIBUTE: 
                case DISCUSSION: 
                case DOMAIN: 
                case JAVA: 
                case LICENSE: 
                case READONLY: 
                case STREAMING: 
                case TEST: 
                case VERSION: 
                case VFILER: 
                case REMARK: {
                    break;
                }
                default: {
                    logger.internal("Stopping Api on " + (Object)((Object)tag.getType()));
                    break block11;
                }
            }
            q.poll();
            if (field != null) {
                field.populate(q);
                if (this.parser.getFilter().includeField(field)) {
                    this.addField(field);
                } else {
                    logger.internalTrace("Filtered field %s.%s", this.name, field);
                }
            }
            if (typedef != null) {
                typedef.populate(q);
            }
            tag = q.peek();
        }
        if (this.namespace == null) {
            if (this.parser.isPrintLogEnabled()) {
                logger.info((MessageKey)MsgKey.ZAPI_PARSER_API_DEFAULT_NAMESPACE, this);
            }
            this.setNamespace("filer");
        }
        if (this.parser.getFilter().includeApi(this)) {
            this.namespace.addType(this);
        }
    }

    public Set<String> getErrors() {
        return this.errno;
    }

    public Set<String> getFamily() {
        return this.family;
    }

    public boolean isIterStart() {
        ApiField tagOutputField = this.getField(ITER_FIELD_NAME_TAG, false, true);
        ApiField recordsOutputField = this.getField(ITER_FIELD_NAME_RECORDS, false, true);
        return this.name.endsWith("-start") && tagOutputField != null && "string".equals(tagOutputField.getType()) && recordsOutputField != null && "integer".equals(recordsOutputField.getType());
    }

    public boolean isIterNext() {
        ApiField tagInputField = this.getField(ITER_FIELD_NAME_TAG, true, false);
        ApiField maximumInputField = this.getField(ITER_FIELD_NAME_MAXIMUM, true, false);
        ApiField recordsOutputField = this.getField(ITER_FIELD_NAME_RECORDS, false, true);
        ApiField listOutputField = this.findSingleCollectionOutputField();
        return this.name.endsWith("-next") && tagInputField != null && "string".equals(tagInputField.getType()) && maximumInputField != null && "integer".equals(maximumInputField.getType()) && recordsOutputField != null && "integer".equals(recordsOutputField.getType()) && listOutputField != null;
    }

    public boolean isIterEnd() {
        ApiField tagInputField = this.getField(ITER_FIELD_NAME_TAG, true, false);
        return this.name.endsWith("-end") && tagInputField != null && "string".equals(tagInputField.getType());
    }

    public boolean isGetIter() {
        return this.isCMode() && this.getField(ITER_FIELD_NAME_TAG, true, false) != null && this.getField(GET_ITER_FIELD_NAME_QUERY, true, false) != null && this.getField(GET_ITER_FIELD_NAME_DESIRED_ATTRIBUTES, true, false) != null;
    }

    public ApiField findSingleCollectionOutputField() {
        ApiField singleCollectionOutputField = null;
        for (Field field : this.getFields()) {
            ApiField apiField = (ApiField)field;
            if (!apiField.isOutput() || !apiField.isCollection()) continue;
            if (singleCollectionOutputField != null) {
                return null;
            }
            singleCollectionOutputField = apiField;
        }
        return singleCollectionOutputField;
    }

    public boolean isCMode() {
        return this.family.contains(FAMILY_CMODE);
    }

    @Override
    protected void addWordReplacements(GeneratorFactory<?, ?, ?, ?> generatorFactory) {
        super.addWordReplacements(generatorFactory);
        if (this.name.endsWith("-start") || this.name.endsWith("-next") || this.name.endsWith("-end")) {
            generatorFactory.getDescriptionGenerator().addWordReplacement(this.name.replaceAll("(-start|-next|-end)", "-*"), ((NameGenerator)generatorFactory.getTypeGenerator(this)).getNameGenerated().replaceAll("(Start|Next|End)", "*"));
            generatorFactory.getDescriptionGenerator().addWordReplacement(this.name.replaceAll("(-start|-next|-end)", ""), ((NameGenerator)generatorFactory.getTypeGenerator(this)).getNameGenerated());
        }
    }

    @Override
    void assertEquivalentTo(Type thatType) throws IncompatibleTypesException {
        if (!(thatType instanceof Api)) {
            throw new IncompatibleTypesException(this, thatType, "Expected API type, was " + thatType.getClass());
        }
        Api that = (Api)thatType;
        this.assertEquivalientTo(that, this.getInputFields(), that.getInputFields());
        this.assertEquivalientTo(that, this.getOutputFields(), that.getOutputFields());
    }

    @SuppressWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public class ApiField
    extends Field {
        boolean input;
        boolean output;

        public ApiField(String name) {
            super(Api.this, name);
        }

        public boolean isInput() {
            return this.input;
        }

        public boolean isOutput() {
            return this.output;
        }

        @Override
        public int compareTo(Field obj) {
            if (obj instanceof ApiField) {
                ApiField apiField = (ApiField)obj;
                return new CompareToBuilder().appendSuper(super.compareTo(obj)).append(this.input, apiField.input).append(this.output, apiField.output).toComparison();
            }
            return super.compareTo(obj);
        }
    }
}

