/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.zapi.generator;

import com.netapp.nmsdk.common.util.Transformer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class WordReplacementTransformer
implements Transformer<String, String> {
    private final Map<String, String> wordsToReplace = new HashMap<String, String>();

    public void addWordReplacement(String wordToReplace, String newWord) {
        this.wordsToReplace.put(wordToReplace, newWord);
    }

    @Override
    public String transform(String original) {
        if (original == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(original.length());
        String delimiters = " \t\n\r\"'()<>&;.,:";
        StringTokenizer st = new StringTokenizer(original, delimiters, true);
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            String newWord = this.wordsToReplace.get(word);
            if (newWord != null) {
                result.append(newWord);
                continue;
            }
            result.append(word);
        }
        return result.toString();
    }
}

