/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.xml;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.TransformerFactory;
import net.jcip.annotations.Immutable;

public class JaxpContext {
    private static Stax stax = new Stax();
    private static Dom dom = new Dom();
    private static Transform transform = new Transform();

    private JaxpContext() {
    }

    public static Stax stax() {
        return stax;
    }

    public static Dom dom() {
        return dom;
    }

    public static Transform transform() {
        return transform;
    }

    public static class Transform {
        private final ThreadLocal<TransformerFactory> transformerFactory = new ThreadLocal<TransformerFactory>(){

            @Override
            protected TransformerFactory initialValue() {
                return TransformerFactory.newInstance();
            }
        };

        private Transform() {
        }

        public TransformerFactory transformerFactory() {
            return this.transformerFactory.get();
        }
    }

    public static class Dom {
        private final ThreadLocal<DocumentBuilder> documentBuilder = new ThreadLocal<DocumentBuilder>(){

            @Override
            protected DocumentBuilder initialValue() {
                try {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    return factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw Throwables.propagate(e);
                }
            }
        };

        private Dom() {
        }

        public DocumentBuilder documentBuilder() {
            return this.documentBuilder.get();
        }
    }

    @Immutable
    public static class Stax {
        private final ThreadLocal<XMLInputFactory> xmlInputFactory = new ThreadLocal<XMLInputFactory>(){

            @Override
            protected XMLInputFactory initialValue() {
                XMLInputFactory f = XMLInputFactory.newInstance();
                f.setProperty("javax.xml.stream.supportDTD", false);
                f.setProperty("javax.xml.stream.isCoalescing", true);
                return f;
            }
        };
        private final ThreadLocal<XMLOutputFactory> xmlOutputFactory = new ThreadLocal<XMLOutputFactory>(){

            @Override
            protected XMLOutputFactory initialValue() {
                return XMLOutputFactory.newInstance();
            }
        };
        private final ThreadLocal<XMLEventFactory> xmlEventFactory = new ThreadLocal<XMLEventFactory>(){

            @Override
            protected XMLEventFactory initialValue() {
                return XMLEventFactory.newInstance();
            }
        };
        private final StaxImplementation implementation = Stax.detectStaxImplementation();

        private Stax() {
        }

        public XMLInputFactory xmlInputFactory() {
            return this.xmlInputFactory.get();
        }

        public XMLOutputFactory xmlOutputFactory() {
            return this.xmlOutputFactory.get();
        }

        public XMLEventFactory xmlEventFactory() {
            return this.xmlEventFactory.get();
        }

        public StaxImplementation getImplementation() {
            return this.implementation;
        }

        private static StaxImplementation detectStaxImplementation() {
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            for (StaxImplementation staxImplementation : StaxImplementation.values()) {
                if (!staxImplementation.isInstance(xmlInputFactory)) continue;
                return staxImplementation;
            }
            throw new IllegalStateException("Unable to determine StAX implementation: " + xmlInputFactory.getClass());
        }

        @VisibleForTesting
        public static synchronized void setImplementation(StaxImplementation staxImplementation) {
            staxImplementation.setSystemProperties();
            stax = new Stax();
        }

        @VisibleForTesting
        public static synchronized void resetImplementation() {
            System.getProperties().remove("javax.xml.stream.XMLInputFactory");
            System.getProperties().remove("javax.xml.stream.XMLOutputFactory");
            System.getProperties().remove("javax.xml.stream.XMLEventFactory");
            stax = new Stax();
        }

        public static enum StaxImplementation {
            WOODSTOX{

                @Override
                boolean isInstance(XMLInputFactory xmlInputFactory) {
                    try {
                        return Class.forName("com.ctc.wstx.stax.WstxInputFactory", true, Thread.currentThread().getContextClassLoader()).isInstance(xmlInputFactory);
                    }
                    catch (ClassNotFoundException e) {
                        return false;
                    }
                }

                @Override
                void setSystemProperties() {
                    System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
                    System.setProperty("javax.xml.stream.XMLOutputFactory", "com.ctc.wstx.stax.WstxOutputFactory");
                    System.setProperty("javax.xml.stream.XMLEventFactory", "com.ctc.wstx.stax.WstxEventFactory");
                }
            }
            ,
            SJSXP{

                @Override
                boolean isInstance(XMLInputFactory xmlInputFactory) {
                    try {
                        return Class.forName("com.sun.xml.internal.stream.XMLInputFactoryImpl", true, Thread.currentThread().getContextClassLoader()).isInstance(xmlInputFactory);
                    }
                    catch (ClassNotFoundException e) {
                        return false;
                    }
                }

                @Override
                void setSystemProperties() {
                    System.setProperty("javax.xml.stream.XMLInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl");
                    System.setProperty("javax.xml.stream.XMLOutputFactory", "com.sun.xml.internal.stream.XMLOutputFactoryImpl");
                    System.setProperty("javax.xml.stream.XMLEventFactory", "com.sun.xml.internal.stream.events.XMLEventFactoryImpl");
                }
            };


            abstract boolean isInstance(XMLInputFactory var1);

            abstract void setSystemProperties();
        }
    }
}

