/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.util;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class StringUtils {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();

    private StringUtils() {
        throw new RuntimeException("StringUtils may not be instantiated");
    }

    public static boolean isEmpty(String string) {
        return string == null || string.equals("");
    }

    public static boolean isBlank(String string) {
        return string == null || string.trim().equals("");
    }

    public static String initialUpperCase(String string) {
        StringBuffer b = new StringBuffer();
        if (string.length() > 0) {
            b.append(string.substring(0, 1).toUpperCase());
        }
        if (string.length() > 1) {
            b.append(string.substring(1));
        }
        return b.toString();
    }

    public static String initialLowerCase(String string) {
        StringBuffer b = new StringBuffer();
        if (string.length() > 0) {
            b.append(string.substring(0, 1).toLowerCase());
        }
        if (string.length() > 1) {
            b.append(string.substring(1));
        }
        return b.toString();
    }

    public static int countInitialUpperCaseChars(String string) {
        char c;
        int i;
        for (i = 0; i < string.length() && Character.isUpperCase(c = string.charAt(i)); ++i) {
        }
        return i;
    }

    public static String coalesce(String ... strings) {
        String output = null;
        for (String v : strings) {
            if (StringUtils.isEmpty(v)) continue;
            output = v;
            break;
        }
        return output;
    }

    public static String[] findRegExMatches(String patternStr, CharSequence input) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            int groupCount = matcher.groupCount();
            String[] result = new String[groupCount];
            for (int i = 0; i < groupCount; ++i) {
                result[i] = matcher.group(i + 1);
            }
            return result;
        }
        return null;
    }

    public static boolean containsAny(String s, String ... substrings) {
        for (String substring : substrings) {
            if (!s.contains(substring)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUpperCase(String s) {
        return s.equals(s.toUpperCase());
    }

    public static boolean stringContainsChar(String s, Collection<Character> chars) {
        for (Character character : chars) {
            if (s.indexOf(character.charValue()) < 0) continue;
            return true;
        }
        return false;
    }

    public static String paddedToString(int n, int digits) {
        String s = "" + n;
        if (s.length() < digits) {
            s = "000000000000000000000000000000".substring(0, digits - s.length()) + s;
        }
        return s;
    }

    public static String paddedToString(String s, int size) {
        if (s.length() < size) {
            s = s + "                        ".substring(0, size - s.length());
        }
        return s;
    }

    public static String leftPaddedToString(String s, int size) {
        if (s.length() < size) {
            s = "                        ".substring(0, size - s.length()) + s;
        }
        return s;
    }

    public static String reflectiveToString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return "String[value=" + (String)o + "]";
        }
        ToStringStyle toStringStyle = new ToStringStyle(){
            {
                this.setUseShortClassName(true);
                this.setUseIdentityHashCode(false);
            }

            @Override
            public void append(StringBuffer buffer, String fieldName, Object fieldValue, Boolean fullDetail) {
                if (fieldValue instanceof String || fieldValue instanceof Integer || fieldValue instanceof Boolean || fieldValue instanceof Long) {
                    super.append(buffer, fieldName, fieldValue, fullDetail);
                } else {
                    super.append(buffer, fieldName, StringUtils.reflectionToString(fieldValue, this), fullDetail);
                }
            }
        };
        return StringUtils.reflectionToString(o, toStringStyle);
    }

    private static String reflectionToString(Object object, ToStringStyle toStringStyle) {
        ReflectionToStringBuilder reflectionToStringBuilder = new ReflectionToStringBuilder(object, toStringStyle, null, Object.class, false, false);
        reflectionToStringBuilder.setExcludeFieldNames(new String[]{"password"});
        return reflectionToStringBuilder.toString();
    }

    public static Set<String> toStringSet(Object[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        HashSet<String> stringSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            stringSet.add(stringArray[i].toString());
        }
        return stringSet;
    }

    public static String collectionToString(Collection<? extends Object> c, String delimiter) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<? extends Object> i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            stringBuilder.append(o.toString());
            if (!i.hasNext()) continue;
            stringBuilder.append(delimiter);
        }
        return stringBuilder.toString();
    }

    public static String numberToStringNoCommas(Object number) {
        return NUMBER_FORMAT.format(number);
    }

    public static boolean endsWithIgnoreCase(String s, String suffix) {
        if (s.length() < suffix.length()) {
            return false;
        }
        String suffixToCheck = s.substring(s.length() - suffix.length(), s.length());
        return suffixToCheck.equalsIgnoreCase(suffix);
    }

    public static int countCharactersInString(String s, char c) {
        if (s == null) {
            return 0;
        }
        int counter = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++counter;
        }
        return counter;
    }

    public static String getCamelCase(String value) {
        String retVal = value;
        if (!StringUtils.isEmpty(value)) {
            value = value.toLowerCase();
            String[] split = value.split(" ");
            StringBuilder master = new StringBuilder();
            for (String string : split) {
                StringBuilder sb = new StringBuilder(string);
                String substring = sb.substring(0, 1).toUpperCase();
                sb.deleteCharAt(0).insert(0, substring);
                master.append(sb.toString()).append(" ");
            }
            retVal = master.toString().trim();
        }
        return retVal;
    }

    public static String nullSafe(String s) {
        return s == null ? "" : s;
    }

    public static String truncate(String input, int maxLength) {
        if (maxLength < input.length()) {
            input = input.substring(0, maxLength);
        }
        return input;
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

