/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.nmsdk.common.logging;

import com.netapp.nmsdk.common.logging.Bundle;
import com.netapp.nmsdk.common.logging.LogLevel;
import com.netapp.nmsdk.common.logging.LoggingException;
import com.netapp.nmsdk.common.logging.MessageKey;
import com.netapp.nmsdk.common.logging.NALogger;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.regex.Matcher;

public class MessageBundle {
    private static final String DEFAULT_BUNDLE_NAME = "messages";
    private static Map<Class<? extends MessageKey>, MessageBundle> instances = new WeakHashMap<Class<? extends MessageKey>, MessageBundle>();
    private static NALogger logger = NALogger.getLogger(MessageBundle.class);
    private ResourceBundle bundle;

    private MessageBundle(Class<? extends MessageKey> clazz) {
        String bundleName = DEFAULT_BUNDLE_NAME;
        Bundle annotation = clazz.getAnnotation(Bundle.class);
        if (annotation != null) {
            bundleName = annotation.value();
        }
        if (logger.isLogLevelEnabled(LogLevel.DEBUG)) {
            logger.internal("Loading resource bundle from " + bundleName + " for " + clazz.getName());
        }
        try {
            this.bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), clazz.getClassLoader());
        }
        catch (MissingResourceException e) {
            throw new LoggingException("Error loading resource bundle " + bundleName + " for class " + clazz, e);
        }
    }

    static MessageBundle getInstance(MessageKey key) {
        Class<?> clazz = key.getClass();
        MessageBundle ret = instances.get(clazz);
        if (ret == null) {
            ret = new MessageBundle(clazz);
            instances.put(clazz, ret);
        }
        return ret;
    }

    public static String localizeMessage(MessageKey key) {
        return MessageBundle.getInstance((MessageKey)key).bundle.getString(key.getPropertyName());
    }

    public static String localizeMessage(MessageKey key, Object ... params) {
        String substitutedLocalizedMessage;
        block3: {
            String unsubstitutedLocalizedMessage = MessageBundle.localizeMessage(key);
            if (params == null || params.length == 0) {
                return unsubstitutedLocalizedMessage;
            }
            substitutedLocalizedMessage = null;
            try {
                substitutedLocalizedMessage = String.format(unsubstitutedLocalizedMessage, params);
            }
            catch (IllegalFormatException e) {
                String args = Arrays.deepToString(params);
                substitutedLocalizedMessage = key.toString() + " " + args;
                if (!logger.isLogLevelEnabled(LogLevel.DEBUG)) break block3;
                logger.internal("Exception while formatting " + key.toString() + " " + MessageBundle.localizeMessage(key).replaceAll("%", "%%") + " " + args + " : " + e.getLocalizedMessage(), e, new Object[0]);
            }
        }
        return substitutedLocalizedMessage;
    }

    public static String code(MessageKey key) {
        return MessageBundle.code(MessageBundle.localizeMessage(key));
    }

    public static String code(String msg) {
        Matcher m = MessageKey.CODE_PATTERN.matcher(msg);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }
}

