#!/bin/bash  
# Ticket 14130944

config='/etc/noris-rdpscan/hostlist'
sender=14130944@ticket.noris.net
mailto=${1:-incident@noris.net}
IPv6=""

cat $config | while read ip fqdn flags; do
      
        if [[ $ip =~ ":" ]]; then
		IPv6="-6"
		# break # das muss wieder raus, wenn ipv6 toll ist !	
	else
		IPv6=""
	fi

	if nmap $IPv6 -T Insane -sS -p 3389 --open "$ip" | grep -q "3389/tcp open"; then

		mail="From: 14130944@ticket.noris.net
X-noris-CI-IP: $fqdn
X-noris-Ticket-Kunde: $fqdn
X-noris-Ticket-Type: Incident
X-noris-Ticket-Priority: 4
X-noris-Ticket-AppendKey: RDP-Scan $fqdn
MIME-Version: 1.0
Content-Type: text/plain; charset=UTF-8
Content-Transfer-Encoding: 8bit
From: $sender
To: $mailto
Subject: RDP-Scan $fqdn

Auf dem Host $fqdn, für den wir
offenbar Betriebsführung haben (Flags $flags),
ist der RDP-Dienst aus dem Internet erreichbar.
Daher ist es hier erforderlich,
* personalisierte Administrator-Benutzerkonten einzurichten,
* Remote-Administator-Anmeldungen nur noch mit diesen Konten zu
  ermöglichen und
* die Absicherung des Systems anschließend in der POP-Datenbank
  mit dem Flag „personalized_logins“ zu kennzeichnen.

Weitere Informationen siehe „Anweisung: Kennwortvergabe und
Berechtigungen“ (DS#F-45195)."
		echo "$mail" | /usr/sbin/sendmail -f "$sender" "$mailto"
	fi
done
