#!/usr/bin/perl
#/* =======================================================================
#|
#|  MODULE  DataProtector omnidbrestore.pl
#|  FILE    omnidbrestore.pl
#|  RCS     $Header: /db/pandbrestore/omnidbrestore.pl $Rev: 1 $ $Date:: 2011-12-18 15:43:02 #$:
#|
#|  DESCRIPTION
#|      omnidbrestore wrapper to omniofflr 
#|      Calls omniofflr with parameters for IDB offline restore
#|
# ========================================================================== */
BEGIN
{
    push(@INC, "$ENV{DP_HOME_DIR}/lib/perl");
}

use Switch;

my $executable = "omniofflr";


########################################
sub ObsoletedMessage()                 #
########################################
{
    print "\n";
    print "\n======================================================================\n";
    print "\n*** NOTE:  omnidbrestore was obsoleted! Please use Omniofflr instead. ***\n";    
    print "\n======================================================================\n";
    print "\n";
}


########################################
sub ExecuteCommand()                   #
########################################
{
    my $argc = @ARGV;

    ObsoletedMessage();
    print "Executing \"Omniofflr -idb\" with the provided $argc parameter(s):\n";
    my $commandLine = "${executable} -idb @{ARGV}";
    print "-\> \"$commandLine\"\n\n\n"; 
    

    #*** execute and report errors ***
    $! = 0;
    my $execReturn = system ($commandLine);
    ObsoletedMessage();
    if (${execReturn} != 0)
    {
        print STDERR "\nError reported while executing $executable: $?  $! \n";
        print STDERR "  commandline: \"$commandLine\"\n";
        
        #*** additional error handling messages ***
        switch($execReturn)
        {
            case -1 
            {
                print STDERR "Please check if omniofflr is executable and its directory";
                print STDERR " in the system PATH.\n";
            }
            else 
            { 
                print STDERR "Please see also the errors reported by omniofflr for more details.";
            }
        }

        print STDERR "\n\n";
        exit $execReturn;
    }
    print "\n\n";
}


########################################
#      MAIN                            #
########################################
ExecuteCommand();
exit 0;

