#! perl

use File::ShLock;
use POSIX '_exit';

print "1..8\n";

{
	# Basic lock
    my $l1 = new File::ShLock("test");
    print ref $l1 ? "ok 1\n" : "not ok 1\n";

	# Colliding lock => fails
    my $l2 = new File::ShLock("test");
    print ref $l2 ? "not ok 2\n" : "ok 2\n";

	# Colliding lock => fails
    my $l2 = new File::ShLock("test");
    print ref $l2 ? "not ok 3\n" : "ok 3\n";
}

{
    my $l3 = new File::ShLock("test");
    print ref $l3 ? "ok 4\n" : "not ok 4\n";
}

if(fork() == 0) {
	$|=1; # autoflush stdout
    my $l4 = new File::ShLock("test");
    print ref $l4 ? "ok 5\n" : "not ok 5\n";
    _exit(0); # don't clean up the lock file
}
wait;

{
	# stale lock, will be ignored
	$DB::single = 1;
    my $l5 = new File::ShLock("test");
    print ref $l5 ? "ok 6\n" : "not ok 6\n";
}

if(fork() == 0) {
	# create a lock for the parent
    my $l6 = new File::ShLock(name=>"test",pid=>getppid);
    print ref $l6 ? "ok 7\n" : "not ok 7\n";
    _exit(0); # don't clean up the lock file
}
sleep(3);
{
	# fails, the lock exists
    my $l7 = new File::ShLock("test");
    print ref $l7 ? "not ok 8\n" : "ok 8\n";
}
