#!/usr/bin/perl
use strict;
use DBI;
use DBD::mysql;
use Getopt::Std;

my %opts;
getopts ":-h:-u:-p:",\%opts;

if (!defined $opts{'u'}) {
	print &usage;
	exit 3;
} elsif (!defined $opts{'h'}) {
	print &usage;
	exit 3;
}

sub usage () {
	print "USAGE:\t$0 -h hostname -u username -p password\n";
}

my $driver = "mysql";
my $dsn = "DBI:$driver:database=pop;hostname=$opts{'h'}";
my $dbh = DBI->connect($dsn, $opts{'u'}, "$opts{'p'}");

unless (defined $dbh) {
	print "Can't connect to mysql Server\n";
	exit 2;
}

my $freeline = "";

my $sth = $dbh->prepare("show table status from pop like 'ticketid'");
$sth->execute();

while (my @arg = $sth->fetchrow_array()) {
	$freeline = $arg[17];
}

$sth->finish();
$dbh->disconnect();

my @freeline = split(/\s/,$freeline);
my $free = int(((($freeline[2] / 1024 / 1024) * 100) + 0.05)/100);

if ($free > 10) {
	print "Es ist noch genuegend Platz frei: $free GB\n";
	exit 0;
} elsif ($free < 10 and $free > 2) {
	print "Der Platz wird langsam knapp: $free GB\n";
	exit 1;
} elsif ($free <= 2) {
	print "Langsam sollte etwas getan werden !!! der Platz wird knapp: $free GB\n";
	exit 2;
}
