#!/usr/bin/perl
use strict;
use Getopt::Std;

my %opts;
getopts ":-h",\%opts;

if (defined $opts{'h'}) {
	print "USAGE:\t$0\n";
	exit 1;
}


open(PROC, "ls /proc |");
	my @proc = <PROC>;
close(PROC);

my $safe = 0;

foreach my $proc (@proc) {
	chomp $proc;
	if ($proc =~ /^\d+$/) {
		open(STAT, "< /proc/$proc/status");
			my @stat = <STAT>;
		close(STAT);
		my $statline = $stat[0];
		chomp $statline;
		my @statline = split(/\s+|\s/,$statline);
		if ($statline[1] eq "mysqld_safe") {
			$safe++;
		}
	}
}


if ($safe > 1) {
	print "Achtung es laeuft nicht nur ein safe_mysql Prozess sondern $safe !!!\n";
	exit 2;
} elsif ($safe < 1) {
	print "Achtung es laeuft kein safe_mysqld Prozess mehr !!!\n";
	exit 2;
} elsif ($safe == 1) {
	print "Alles OK\n";
	exit 0;
}
