#!/usr/bin/perl
use strict;
use DBI;
use DBD::mysql;
use Getopt::Std;

my %opts;
getopts ":-h:-u:-p:",\%opts;

if (!defined $opts{'h'}) {
	&usage();
} elsif (!defined $opts{'u'}) {
	&usage();
}

sub usage () {
	print "USAGE:\t$0 -h hostname -u username -p password\n";
	exit 1;
}

my $driver = "mysql";
my $dsn = "DBI:$driver:database=pop;hostname=$opts{'h'}";
my $dbh = DBI->connect($dsn,$opts{'u'},"$opts{'p'}");

unless (defined $dbh) {
	print "USAGE:\t$0 -h hostname -u username -p password\n";
	exit 1;
}

my $sth = $dbh->prepare("show tables");
$sth->execute();

my @rowdata;

while (my @tables = $sth->fetchrow_array()) {
	my $sth2 = $dbh->prepare("show table status from pop like '$tables[0]'");
	$sth2->execute();
	while (my @row = $sth2->fetchrow_array()) {
		my @options = split(/\s/,$row[13]);
		foreach my $options (@options) {
			my @values = split(/=/,$options);
			if ($values[0] eq "max_rows") {
				my $diff = $values[1] - $row[3];
				my %tmp = (
						'table'		=>	$tables[0],
						'ist'		=>	$row[3],
						'soll'		=>	$values[1],
						'diff'		=>	$diff
					   );
				push(@rowdata,\%tmp);
				
			}
		}
	}
	$sth2->finish();
}
$sth->finish();
$dbh->disconnect();

my @status;
my $exitcode = 0;

foreach my $rowdata (@rowdata) {
	my %rowdata = %$rowdata;
	if ($rowdata{'diff'} <= 5000) {
		push(@status,"Achtung !!! Noch $rowdata{'diff'} Datensaetze und die Tabelle $rowdata{'table'} ist voll !!!\n");
		$exitcode = 2;
	} elsif ($rowdata{'diff'} > 5000 and $rowdata{'diff'} <= 30000) {
		push(@status,"Es sind nur noch $rowdata{'diff'} Datensaetze frei, bis Tabelle $rowdata{'table'} voll ist !!!\n");
		if ($exitcode == 0 or $exitcode == 1) {
			$exitcode = 1;
		}
	}
}

if ($exitcode == 0) {
	print "Alles OK\n";
	exit 0;
} else {
	foreach (@status) {
		print $_;
	}
	exit $exitcode;
}
