#!/usr/bin/perl
use strict;
use DBI;
use DBD::mysql;
use Getopt::Std;


my %opts;
getopts ":-h:-u:-p:",\%opts;

if (!defined $opts{'h'}) {
	&usage();
	exit 1;
} elsif (!defined $opts{'u'}) {
	&usage();
	exit 1;
}

sub usage () {
	print "USAGE:\t$0 -h hostname -u username -p password\n";
}

my $driver = "mysql";
my $dsn = "DBI:$driver:database=;hostname=$opts{'h'}";
my $dbh = DBI->connect($dsn,$opts{'u'},"$opts{'p'}");

unless (defined $dbh) {
	print "Can't connect to mysql Server: $@\n";
	exit 2;
}

$dbh->disconnect();

print "Alles OK\n";
exit 0;
