#
# check_multi.cmd
#
# sample config file for check_multi plugin
#
# (c) Matthias Flacke, 2007-8
#
#--- some local checks on the nagios system
#
#--- network
command[ network_icmp ]		= check_icmp -H localhost -w 500,5% -c 1000,10%

#--- processes
command[ procs_total ]		= check_procs
command[ procs_RSS ]		= check_procs -w 500000 -c 1000000 --metric=RSS
command[ procs_zombie ]		= check_procs -w 1 -c 2 -s Z
command[ proc_acpid ]		= check_procs -c 1: -C acpid
command[ proc_automount ]	= check_procs -c 1: -C automount
command[ proc_cron ]		= check_procs -c 1: -C cron
command[ proc_httpd ]		= check_procs -c 1: -C httpd2-prefork
command[ proc_smartd ]		= check_procs -c 1: -C smartd
command[ proc_snmpd ]		= check_procs -c 1: -C snmpd
command[ proc_syslogd ]		= check_procs -c 1: -C syslog-ng
command[ proc_xinetd ]		= check_procs -c 1: -C xinetd

#--- system parameters
command[ system_load ]		= check_load -w 5,4,3 -c 10,8,6
command[ system_mail ]		= check_tcp -H localhost -p 25
command[ system_mailqueue ]	= check_mailq -w 2 -c 4
command[ system_mysql ]		= check_mysql -u admin
command[ system_ntp ]		= check_ntp -H ntp1.fau.de
command[ system_portmapper ]	= check_rpc -H localhost -C portmapper
command[ system_rootdisk ]	= check_disk -w 5% -c 2% -p /
command[ system_ssh ]		= check_ssh localhost
command[ system_swap ]		= check_swap -w 90 -c 80
command[ system_syslog ]	= check_file_age -f /var/log/messages -c 86400 -C 0
command[ system_users ]		= check_users -w 5 -c 10

#--- nagios check for your local nagios system
command[ nagios_system ]	= check_nagios -F /usr/local/nagios/var/nagios.log -e 5 -C nagios
command[ nagios_tac ]		= check_http -H localhost -u "http://localhost/nagios/cgi-bin/tac.cgi" -a guest:guest

#--- some external checks (need internet connection)
command[ nagios_icmp ]		= check_icmp -H www.nagios.org -w 500,5% -c 1000,10%
command[ nagios_org_dns ]	= check_dns -H www.nagios.org
command[ nagios_org_http ]	= check_http -H www.nagios.org

#--- some dummy plugin calls just to show the different states
command[ dummy_ok ]		= check_dummy 0 "should be OK state"
command[ dummy_warning ]	= check_dummy 1 "should be WARNING state"
command[ dummy_critical ]	= check_dummy 2 "should be CRITICAL state"
command[ dummy_unknown ]	= check_dummy 3 "should be UNKNOWN state"
