package noris::UsernameToCustomers;

use strict;
use warnings;

use lib (qw(/usr/pop/lib));

use noris::REST::Frontend (qw(query kunden));
use Exporter;

@noris::UsernameToCustomers::EXPORT_OK = (qw(username_to_customer_list));
@noris::UsernameToCustomers::ISA = (qw(Exporter));

our $rest_script = 'get_kunden_by_user.name';

return (1);

sub username_to_customer_list
{
	my $user_name = shift;
	my $res = query ($rest_script, 'user.name' => $user_name);
	my $hash;

	if (!$res)
	{
		print STDERR "noris::REST::Frontend::query ($rest_script, user.name => $user_name) failed: " . $res->errstr () . "\n";
		return;
	}

	$hash = $res->data ();
	return (sort (values %$hash));
}
