package CapMan::Plugins::Skeleton;

use strict;
use warnings;

=head1 NAME

CapMan::Plugins::Skeleton - CapMan plugin which doesn't do anything actually

=head1 DESCRIPTION

This is a plugin which shows you how plugins work.

=cut

use CapMan::Config qw(:rrdcreate);
use CapMan::Services qw(:plugin);
use CapMan::Tools qw(write_to_rrd create_rrdfile);

# FIXME Delete the following Line
return (1);

our $GraphDef = ['-v', 'Load',
	'LINE1:c#FF0000:10 Minute Average',
	'GPRINT:c:AVERAGE:%4.1lf Average,',
	'GPRINT:c:MAX:%4.1lf Max,',
	'GPRINT:c:LAST:%4.1lf Last'];

=head1 SERVICES PROVIDED

=over 4

=item name

This is the service which would be provided if this was a real plugin.

=back

=cut

#register_input_handler ('load', '.1.3.6.1.4.1.2021.10.1.5', \&load_handler);
#register_graph_handler ('load', $GraphDef);

sub handler ($$$)
{
	my $host = shift;
	my $srv = shift;
	my $data = shift;

	my @values = ();

	$values[0] = $data->[0][2];
	$values[1] = $data->[1][2];
	$values[2] = $data->[2][2];

	write_to_rrd ($host, $srv, '', \&create_handler, @values);
}

sub create_handler ($)
{
	my $file = shift;

	create_rrdfile ($file,
		"DS:one:GAUGE:$HeartBeat:0:256",
		"DS:five:GAUGE:$HeartBeat:0:256",
		"DS:ten:GAUGE:$HeartBeat:0:256"
	);
}

=head1 SEE ALSO

L<CapMan::Services>

=head1 AUTHOR

Florian octo Forster E<lt>octo@noris.netE<gt> for the noris network AG
L<http://noris.net/>
