#!/bin/bash

cd /var/lib/rrd/capman

ls */*/cpu_linux26*.rrd | while read L26FILE
do
	DIRECTORY=`dirname $L26FILE`;

	echo -n "Migrating $L26FILE.."

	[ -d "/var/tmp/capman/$DIRECTORY" ] || mkdir -p "/var/tmp/capman/$DIRECTORY"
	[ -e "/var/tmp/capman/$L26FILE" ] && continue
	cp "$L26FILE" "/var/tmp/capman/$L26FILE"

	rm "$L26FILE"
	rrdtool dump "/var/tmp/capman/$L26FILE" \
	| /usr/share/doc/rrdtool/examples/add_ds/add_ds.pl 1 'NaN' 'COUNTER' '900' '0' '1000' \
	| sed -e 's/\<ds1\>/stel/g;' \
	| rrdtool restore - "$L26FILE"
	chown snmp: "$L26FILE"

	echo "done";
done
