#!/bin/bash

cd /var/lib/capman

ls */*/cpu_linux26*.rrd | while read L26FILE
do
	DIRECTORY=`dirname $L26FILE`;
	L24FILE=${L26FILE/_linux26/};
	[ -e "$L24FILE" ] || continue;

	echo -n "Migrating $L24FILE -> $L26FILE.."

	[ -d "/tmp/$DIRECTORY" ] || mkdir -p "/var/tmp/capman/$DIRECTORY"
	[ -e "/var/tmp/capman/$L26FILE" ] || cp "$L26FILE" "/var/tmp/capman/$L26FILE"
	[ -e "/var/tmp/capman/$L24FILE" ] || cp "$L24FILE" "/var/tmp/capman/$L24FILE"

	rm "$L26FILE"
	rrdtool dump "$L24FILE" \
	| /usr/share/doc/rrdtool/examples/add_ds/add_ds.pl 3 'NaN' 'COUNTER' '900' '0' '1000' \
	| sed -e 's/\<ds1\>/wait/g; s/\<ds2\>/intr/g; s/\<ds3\>/sitr/g;' \
	| rrdtool restore - "$L26FILE"
	rm "$L24FILE"

	echo "done";
done
