package CapMan::Plugins::Riello;

use strict;
use warnings;

=head1 NAME

CapMan::Plugins::Riello - Temperature information for Riello NetMan

=head1 DESCRIPTION

This is a simple plugin for three more temperature sensors provided by the
Riello-UPS NetMan 100 connected to our UPSes. Since the MIB they use is
apparently proprietary I don't know what all the other stuff does they
provide..

=cut

use CapMan::Config qw(:rrdcreate);
use CapMan::Services qw(:plugin);
use CapMan::Tools qw(write_to_rrd);

=head1 SERVICES PROVIDED

=over 4

=item ups-riello

Temperature of the system, the rectifier and the inverter.

=back

=cut

register_input_handler ('ups-riello', '.1.3.6.1.4.1.5491.1.51.1.5', \&handler);

return (1);

sub handler
{
	confess ("Wrong number of arguments") if (@_ != 4);

	my $customer = shift;
	my $host = shift;
	my $srv = shift;
	my $data = shift;

	for (@$data)
	{
		my ($name, $seq, $val, $type) = @$_;

		my $subname = '';
		
		#if ($name eq '.1.3.6.1.4.1.5491.1.51.1.5.4')
		#{
		#	$subname = 'System';
		#}
		if ($name eq '.1.3.6.1.4.1.5491.1.51.1.5.5')
		{
			$subname = 'Rectifier';
		}
		elsif ($name eq '.1.3.6.1.4.1.5491.1.51.1.5.6')
		{
			$subname = 'Inverter';
		}
		elsif ($::DEBUG)
		{
			print "DEBUG: \$name = $name\n";
		}

		write_to_rrd ($customer, $host, 'temperature', $subname, $val) if ($subname);
	}
}

=head1 SEE ALSO

L<CapMan::Services>, L<http://www.schorisch-energy.de/produkt/tdnet.htm>

=head1 AUTHOR

Florian octo Forster E<lt>octo@noris.netE<gt> for the noris network AG
L<http://noris.net/>
