package CapMan::Plugins::Binary;

use strict;
use warnings;

=head1 NAME

CapMan::Plugins::Binary - CapMan plugin for binary data.

=head1 DESCRIPTION

This plugin is used to graph binary data, such as digital input/output ports.

=cut

use CapMan::Config qw(:rrdcreate);
use CapMan::Services qw(:plugin);
use CapMan::Tools qw(create_rrdfile);

=head1 CREATE HANDLER

=over 4

=item binary

=cut

our $GraphDefBinary = ['-l', '0', '-v', 'True/False',
	'DEF:b={filename}:binary:AVERAGE',
	'AREA:b#00FF00:Digital I/O',
	'GPRINT:b:AVERAGE:%1.2lg Average,',
	'GPRINT:b:MIN:%1.2lg Min,',
	'GPRINT:b:MAX:%1.2lg Max,',
	'GPRINT:b:LAST:%1.2lg Last'];

register_graph_handler  ('binary', $GraphDefBinary);
register_create_handler ('binary', \&binary_create_handler);

return (1);

=head1 GRAPH HANDLER

=over 4

=item B<binary> (I<zero or one>)

=back

=cut

sub binary_create_handler ($)
{
	my $file = shift;

	create_rrdfile ($file, "DS:binary:GAUGE:$HeartBeat:0:1");
}

=head1 SEE ALSO

L<CapMan::Services>

=head1 AUTHOR

Florian octo Forster E<lt>octo@noris.netE<gt> for the noris network AG
L<http://noris.net/>
