package CapMan::Dispatcher;

use strict;
use warnings;

use Exporter;
use SNMP ();

use CapMan::Config qw(get_host_config);
use CapMan::Services qw(service_to_oid run_input_callback);
use CapMan::Tools qw(do_snmp_walk);

=head USAGE

  use CapMan::Dispatcher qw(query_host);

  query_host ($hostname);

=cut

@CapMan::Dispatcher::EXPORT_OK = qw(query_host);
@CapMan::Dispatcher::ISA = qw(Exporter);

return (1);

sub query_host ($$)
{
	my $customer = shift;
	my $host = shift;
	my @services = get_host_config ($customer, $host, 'services');
	my @oids = ();
	my $data;
	my $i;

	for (@services)
	{
		my $s = $_;
		my $o = service_to_oid ($s);

		if (!$o)
		{
			print STDERR qq(No OID/Handler defined for service "$s"\n);
		}
		else
		{
			push (@oids, $o);
		}
	}

	if (!@oids)
	{
		print STDERR qq/No (valid) services defined for host "$host"\n/;
		return;
	}

	$data = do_snmp_walk ($customer, $host, @oids);

	if (!defined ($data))
	{
		print STDERR "Did not get any data from $host\n";
		return;
	}

	print STDOUT 'DEBUG: Dispatching ', scalar (@services), " services for host $host.\n" if ($::DEBUG);
	
	for ($i = 0; $i < scalar (@services); $i++)
	{
		if (!defined ($data->[$i]))
		{
			print STDOUT "DEBUG: No data for service #$i `" . $services[$i] . "'\n" if ($::DEBUG);
			next;
		}
		run_input_callback ($customer, $host, $services[$i], $data->[$i]);
	}
}
