#!/usr/bin/perl

use strict;
use warnings;

my $sensors = [];

my $dh;

opendir ($dh, "/owfs") or die ("opendir (/owfs): $!");
while (my $file = readdir ($dh))
{
	if ((-e "/owfs/$file/temperature")
			&& ($file =~ m/^([0-9a-fA-F][0-9a-fA-F])\.([0-9a-fA-F]{12})(?:[0-9a-fA-F][0-9a-fA-F])?$/))
	{
		push (@$sensors, { family => $1, id => $2, file => $file });
	}
}
closedir ($dh);

for (@$sensors)
{
	my $sensor = $_;
	my $filename = "/owfs/" . $sensor->{'file'} . '/temperature';
	my $fh;
	my $temperature;

	open ($fh, "< $filename");
	if (!$fh)
	{
		warn ("open ($filename): $!");
		next;
	}
	$temperature = <$fh>;
	close ($fh);

	$temperature =~ s/^\s+//;
	$temperature =~ s/\s+$//;

	print "temperature-", $sensor->{'id'}, "=", $temperature, "\n";
} # for (@$sensors)

exit (0);
